/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.sessions.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import org.qubership.integration.platform.sessions.dto.AbstractRunnableElement;
import org.qubership.integration.platform.sessions.dto.SessionElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Schema(description="Single session object")
public class Session
extends AbstractRunnableElement {
    private static final Logger log = LoggerFactory.getLogger(Session.class);
    @Schema(description="Id")
    private String id;
    @Schema(description="Whether this is imported session")
    private boolean importedSession;
    @Schema(description="External id (if it was set during chain execution)")
    private String externalSessionCipId;
    @Schema(description="Id of the chain it was executed on")
    private String chainId;
    @Schema(description="Name of the chain it was executed on")
    private String chainName;
    @Schema(description="Domain on which chain was executed")
    private String domain;
    @Schema(description="qubership-integration-platform-engine pod ip address on which chain was executed")
    private String engineAddress;
    @Schema(description="Value of logging level on a chain at a time chain was executed")
    private String loggingLevel;
    @Schema(description="Deployed snapshot name for the chain")
    private String snapshotName;
    @Schema(description="Correlation id for that execution (if it was set)")
    private String correlationId;
    @Schema(description="Parent of session id for the current session")
    private String parentSessionId;
    @Schema(description="List of session elements (steps) created by this session")
    private List<SessionElement> sessionElements;

    protected Session(SessionBuilder<?, ?> b) {
        super(b);
        this.id = b.id;
        this.importedSession = b.importedSession;
        this.externalSessionCipId = b.externalSessionCipId;
        this.chainId = b.chainId;
        this.chainName = b.chainName;
        this.domain = b.domain;
        this.engineAddress = b.engineAddress;
        this.loggingLevel = b.loggingLevel;
        this.snapshotName = b.snapshotName;
        this.correlationId = b.correlationId;
        this.parentSessionId = b.parentSessionId;
        this.sessionElements = b.sessionElements;
    }

    public static SessionBuilder<?, ?> builder() {
        return new SessionBuilderImpl();
    }

    public String getId() {
        return this.id;
    }

    public boolean isImportedSession() {
        return this.importedSession;
    }

    public String getExternalSessionCipId() {
        return this.externalSessionCipId;
    }

    public String getChainId() {
        return this.chainId;
    }

    public String getChainName() {
        return this.chainName;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getEngineAddress() {
        return this.engineAddress;
    }

    public String getLoggingLevel() {
        return this.loggingLevel;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public String getParentSessionId() {
        return this.parentSessionId;
    }

    public List<SessionElement> getSessionElements() {
        return this.sessionElements;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setImportedSession(boolean importedSession) {
        this.importedSession = importedSession;
    }

    public void setExternalSessionCipId(String externalSessionCipId) {
        this.externalSessionCipId = externalSessionCipId;
    }

    public void setChainId(String chainId) {
        this.chainId = chainId;
    }

    public void setChainName(String chainName) {
        this.chainName = chainName;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setEngineAddress(String engineAddress) {
        this.engineAddress = engineAddress;
    }

    public void setLoggingLevel(String loggingLevel) {
        this.loggingLevel = loggingLevel;
    }

    public void setSnapshotName(String snapshotName) {
        this.snapshotName = snapshotName;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public void setParentSessionId(String parentSessionId) {
        this.parentSessionId = parentSessionId;
    }

    public void setSessionElements(List<SessionElement> sessionElements) {
        this.sessionElements = sessionElements;
    }

    public Session() {
    }

    public static abstract class SessionBuilder<C extends Session, B extends SessionBuilder<C, B>>
    extends AbstractRunnableElement.AbstractRunnableElementBuilder<C, B> {
        private String id;
        private boolean importedSession;
        private String externalSessionCipId;
        private String chainId;
        private String chainName;
        private String domain;
        private String engineAddress;
        private String loggingLevel;
        private String snapshotName;
        private String correlationId;
        private String parentSessionId;
        private List<SessionElement> sessionElements;

        public B id(String id) {
            this.id = id;
            return (B)this.self();
        }

        public B importedSession(boolean importedSession) {
            this.importedSession = importedSession;
            return (B)this.self();
        }

        public B externalSessionCipId(String externalSessionCipId) {
            this.externalSessionCipId = externalSessionCipId;
            return (B)this.self();
        }

        public B chainId(String chainId) {
            this.chainId = chainId;
            return (B)this.self();
        }

        public B chainName(String chainName) {
            this.chainName = chainName;
            return (B)this.self();
        }

        public B domain(String domain) {
            this.domain = domain;
            return (B)this.self();
        }

        public B engineAddress(String engineAddress) {
            this.engineAddress = engineAddress;
            return (B)this.self();
        }

        public B loggingLevel(String loggingLevel) {
            this.loggingLevel = loggingLevel;
            return (B)this.self();
        }

        public B snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return (B)this.self();
        }

        public B correlationId(String correlationId) {
            this.correlationId = correlationId;
            return (B)this.self();
        }

        public B parentSessionId(String parentSessionId) {
            this.parentSessionId = parentSessionId;
            return (B)this.self();
        }

        public B sessionElements(List<SessionElement> sessionElements) {
            this.sessionElements = sessionElements;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "Session.SessionBuilder(super=" + super.toString() + ", id=" + this.id + ", importedSession=" + this.importedSession + ", externalSessionCipId=" + this.externalSessionCipId + ", chainId=" + this.chainId + ", chainName=" + this.chainName + ", domain=" + this.domain + ", engineAddress=" + this.engineAddress + ", loggingLevel=" + this.loggingLevel + ", snapshotName=" + this.snapshotName + ", correlationId=" + this.correlationId + ", parentSessionId=" + this.parentSessionId + ", sessionElements=" + String.valueOf(this.sessionElements) + ")";
        }
    }

    private static final class SessionBuilderImpl
    extends SessionBuilder<Session, SessionBuilderImpl> {
        private SessionBuilderImpl() {
        }

        @Override
        protected SessionBuilderImpl self() {
            return this;
        }

        @Override
        public Session build() {
            return new Session(this);
        }
    }
}

