/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.sessions.mapper;

import java.util.List;
import org.qubership.integration.platform.sessions.dto.Session;
import org.qubership.integration.platform.sessions.dto.opensearch.SessionElementElastic;
import org.qubership.integration.platform.sessions.mapper.SessionAggregateMapper;
import org.qubership.integration.platform.sessions.mapper.SessionElementMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SessionAggregateMapperImpl
extends SessionAggregateMapper {
    @Autowired
    private SessionElementMapper sessionElementMapper;

    @Override
    public List<Session> toPreview(List<SessionElementElastic> elements) {
        if (elements == null) {
            return null;
        }
        List list = this.sessionElementMapper.newList();
        for (SessionElementElastic sessionElementElastic : elements) {
            list.add(this.toPreview(sessionElementElastic));
        }
        return list;
    }

    @Override
    protected Session toPreview(SessionElementElastic element, Session session) {
        if (element == null) {
            return session;
        }
        session.setId(element.getSessionId());
        session.setExternalSessionCipId(element.getExternalSessionId());
        session.setStarted(element.getSessionStarted());
        session.setFinished(element.getSessionFinished());
        session.setDuration(element.getSessionDuration());
        session.setExecutionStatus(element.getSessionExecutionStatus());
        session.setSyncDuration(element.getSessionSyncDuration());
        session.setParentSessionId(element.getParentSessionId());
        session.setImportedSession(element.isImportedSession());
        session.setChainId(element.getChainId());
        session.setChainName(element.getChainName());
        session.setDomain(element.getDomain());
        session.setEngineAddress(element.getEngineAddress());
        session.setLoggingLevel(element.getLoggingLevel());
        session.setSnapshotName(element.getSnapshotName());
        session.setCorrelationId(element.getCorrelationId());
        return session;
    }

    @Override
    protected Session toSession(SessionElementElastic element, List<SessionElementElastic> elements) {
        if (element == null && elements == null) {
            return null;
        }
        Session session = new Session();
        if (element != null) {
            session.setStarted(element.getStarted());
            session.setFinished(element.getFinished());
            session.setDuration(element.getDuration());
            session.setExecutionStatus(element.getExecutionStatus());
            session.setSyncDuration(element.getSyncDuration());
            session.setId(element.getId());
            session.setImportedSession(element.isImportedSession());
            session.setChainId(element.getChainId());
            session.setChainName(element.getChainName());
            session.setDomain(element.getDomain());
            session.setEngineAddress(element.getEngineAddress());
            session.setLoggingLevel(element.getLoggingLevel());
            session.setSnapshotName(element.getSnapshotName());
            session.setCorrelationId(element.getCorrelationId());
            session.setParentSessionId(element.getParentSessionId());
        }
        session.setSessionElements(this.sessionElementMapper.toSessionElements(elements));
        this.fillSession(element, elements, session);
        return session;
    }
}

