/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.sessions.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.qubership.integration.platform.sessions.dto.Session;
import org.qubership.integration.platform.sessions.dto.SessionElement;
import org.qubership.integration.platform.sessions.dto.SessionElementProperty;
import org.qubership.integration.platform.sessions.dto.opensearch.SessionElementElastic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@Mapper(componentModel="spring")
public abstract class SessionElementMapper {
    private static final Logger log = LoggerFactory.getLogger(SessionElementMapper.class);
    private ObjectMapper objectMapper;

    @Autowired
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Mappings(value={@Mapping(target="elementId", source="element.id"), @Mapping(target="camelName", source="element.camelElementName"), @Mapping(target="previousElement", source="element.prevElementId"), @Mapping(target="parentElement", source="element.parentElementId"), @Mapping(target="children", expression="java(newList())"), @Mapping(target="headersBefore", expression="java(convertFromJson(element.getHeadersBefore()))"), @Mapping(target="headersAfter", expression="java(convertFromJson(element.getHeadersAfter()))"), @Mapping(target="propertiesBefore", expression="java(convertPropertiesFromJson(element.getPropertiesBefore()))"), @Mapping(target="propertiesAfter", expression="java(convertPropertiesFromJson(element.getPropertiesAfter()))")})
    public abstract SessionElement toSessionElement(SessionElementElastic var1);

    @Mappings(value={@Mapping(target="id", source="element.elementId"), @Mapping(target="camelElementName", source="element.camelName"), @Mapping(target="prevElementId", source="element.previousElement"), @Mapping(target="parentElementId", source="element.parentElement"), @Mapping(target="started", source="element.started"), @Mapping(target="finished", source="element.finished"), @Mapping(target="duration", source="element.duration"), @Mapping(target="syncDuration", source="element.syncDuration"), @Mapping(target="executionStatus", source="element.executionStatus"), @Mapping(target="sessionStarted", source="session.started"), @Mapping(target="sessionFinished", source="session.finished"), @Mapping(target="sessionDuration", source="session.duration"), @Mapping(target="sessionSyncDuration", source="session.syncDuration"), @Mapping(target="sessionExecutionStatus", source="session.executionStatus"), @Mapping(target="headersBefore", expression="java(convertMapToJson(element.getHeadersBefore()))"), @Mapping(target="headersAfter", expression="java(convertMapToJson(element.getHeadersAfter()))"), @Mapping(target="propertiesBefore", expression="java(convertSessionElementPropertyMapToJson(element.getPropertiesBefore()))"), @Mapping(target="propertiesAfter", expression="java(convertSessionElementPropertyMapToJson(element.getPropertiesAfter()))"), @Mapping(target="chainElementId", expression="java(null)"), @Mapping(target="chainName", source="session.chainName")})
    public abstract SessionElementElastic toSessionElementElastic(SessionElement var1, Session var2);

    public List<SessionElement> toSessionElements(List<SessionElementElastic> elasticElements) {
        List sessionElementList = elasticElements.stream().map(arg_0 -> this.toSessionElement(arg_0)).collect(Collectors.toList());
        return this.rebindElements(sessionElementList);
    }

    public List<SessionElementElastic> toElements(List<Session> sessions) {
        ArrayList<SessionElementElastic> result = new ArrayList<SessionElementElastic>();
        sessions.forEach(session -> result.addAll(this.toElasticElements(session.getSessionElements(), session)));
        return result;
    }

    public List<SessionElementElastic> toElasticElements(List<SessionElement> elements, Session session) {
        ArrayList<SessionElementElastic> result = new ArrayList<SessionElementElastic>();
        if (!CollectionUtils.isEmpty(elements)) {
            for (SessionElement sessionElement : elements) {
                result.add(this.toSessionElementElastic(sessionElement, session));
                result.addAll(this.toElasticElements(sessionElement.getChildren(), session));
            }
        }
        return result;
    }

    private List<SessionElement> rebindElements(List<SessionElement> elementList) {
        Set parentElementsIdList = elementList.stream().map(SessionElement::getParentElement).filter(Objects::nonNull).collect(Collectors.toSet());
        Map<String, SessionElement> parentElementMap = elementList.stream().filter(element -> {
            String elementId = element.getElementId();
            return parentElementsIdList.contains(elementId);
        }).map(element -> {
            element.setChildren(new ArrayList());
            String elementId = element.getElementId();
            return Map.entry(elementId, element);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (element1, element2) -> {
            log.warn("Duplicated session element: {}. Session {} data is inconsistent.", (Object)element1.getElementId(), (Object)element1.getSessionId());
            return element1;
        }));
        List<SessionElement> elementsHierarchy = elementList.stream().filter(element -> {
            String parentElementId = element.getParentElement();
            if (parentElementId != null) {
                SessionElement parentElement = (SessionElement)parentElementMap.get(parentElementId);
                if (parentElement != null) {
                    parentElement.getChildren().add(element);
                } else {
                    parentElementId = null;
                }
            }
            return parentElementId == null;
        }).collect(Collectors.toList());
        this.sortChildrenByStartTime(elementsHierarchy);
        return elementsHierarchy;
    }

    private void sortChildrenByStartTime(List<SessionElement> elementList) {
        elementList.sort((first, second) -> {
            String startedFirstStr = first.getStarted();
            String startedSecondStr = second.getStarted();
            LocalDateTime dateFirst = LocalDateTime.parse(startedFirstStr);
            LocalDateTime dateSecond = LocalDateTime.parse(startedSecondStr);
            boolean isBefore = dateSecond.isBefore(dateFirst);
            return isBefore ? 1 : -1;
        });
        elementList.forEach(nextElement -> {
            List childrenList = nextElement.getChildren();
            this.sortChildrenByStartTime(childrenList);
        });
    }

    protected Map<String, SessionElementProperty> convertPropertiesFromJson(String v2PropsJson) {
        try {
            if (StringUtils.isNotEmpty((CharSequence)v2PropsJson)) {
                return (Map)this.objectMapper.readValue(v2PropsJson, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        catch (JsonProcessingException e) {
            log.error("Error while deserializing json string: {}", (Object)v2PropsJson);
        }
        return Collections.emptyMap();
    }

    protected Map<String, String> convertFromJson(String jsonString) {
        if (StringUtils.isBlank((CharSequence)jsonString)) {
            return null;
        }
        try {
            return (Map)this.objectMapper.readValue(jsonString, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (JsonProcessingException e) {
            log.error("Error while deserializing json string: {}", (Object)jsonString);
            return null;
        }
    }

    protected List newList() {
        return new ArrayList();
    }

    protected String convertMapToJson(Map<String, String> map) {
        try {
            return this.objectMapper.writeValueAsString(map);
        }
        catch (JsonProcessingException e) {
            log.error("Error while serializing map to json: {}", map);
            return null;
        }
    }

    protected String convertSessionElementPropertyMapToJson(Map<String, SessionElementProperty> map) {
        try {
            return this.objectMapper.writeValueAsString(map);
        }
        catch (JsonProcessingException e) {
            log.error("Error while serializing map to json: {}", map);
            return null;
        }
    }
}

