/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.sessions.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.integration.platform.sessions.dto.Session;
import org.qubership.integration.platform.sessions.exception.SessionsNotFoundException;
import org.qubership.integration.platform.sessions.service.SessionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExportService {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH_mm_ss");
    private static final String JSON_EXTENSION = ".json";
    private final SessionService sessionService;
    private final ObjectMapper jsonMapper;

    @Autowired
    public ExportService(SessionService sessionService, ObjectMapper jsonMapper) {
        this.sessionService = sessionService;
        this.jsonMapper = jsonMapper;
    }

    public Pair<String, String> exportSessions(List<String> sessionsIds) throws JsonProcessingException {
        List sessions = sessionsIds.stream().map(id -> this.sessionService.findById(id, "sessionId", false, true)).collect(Collectors.toList());
        if (sessions.isEmpty()) {
            throw new SessionsNotFoundException("Sessions not found");
        }
        return this.getExportedSessions(((Session)sessions.get(0)).getChainId(), sessions);
    }

    private Pair<String, String> getExportedSessions(String chainId, List<Session> sessions) throws JsonProcessingException {
        String json = this.jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString(sessions);
        return Pair.of((Object)("chain-sessions-" + chainId + "-(" + DATE_FORMAT.format(new Date()) + ").json"), (Object)json);
    }
}

