/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.sessions.mapper;

import org.qubership.integration.platform.sessions.dto.Session;
import org.qubership.integration.platform.sessions.dto.SessionElement;
import org.qubership.integration.platform.sessions.dto.opensearch.SessionElementElastic;
import org.qubership.integration.platform.sessions.mapper.SessionElementMapper;
import org.springframework.stereotype.Component;

@Component
public class SessionElementMapperImpl
extends SessionElementMapper {
    @Override
    public SessionElement toSessionElement(SessionElementElastic element) {
        if (element == null) {
            return null;
        }
        SessionElement.SessionElementBuilder<?, ?> sessionElement = SessionElement.builder();
        sessionElement.elementId(element.getId());
        sessionElement.camelName(element.getCamelElementName());
        sessionElement.previousElement(element.getPrevElementId());
        sessionElement.parentElement(element.getParentElementId());
        sessionElement.started(element.getStarted());
        sessionElement.finished(element.getFinished());
        sessionElement.duration(element.getDuration());
        sessionElement.executionStatus(element.getExecutionStatus());
        sessionElement.syncDuration(element.getSyncDuration());
        sessionElement.sessionId(element.getSessionId());
        sessionElement.chainElementId(element.getChainElementId());
        sessionElement.actualElementChainId(element.getActualElementChainId());
        sessionElement.elementName(element.getElementName());
        sessionElement.bodyBefore(element.getBodyBefore());
        sessionElement.bodyAfter(element.getBodyAfter());
        sessionElement.contextBefore(this.convertFromJson(element.getContextBefore()));
        sessionElement.contextAfter(this.convertFromJson(element.getContextAfter()));
        sessionElement.exceptionInfo(element.getExceptionInfo());
        sessionElement.children(this.newList());
        sessionElement.headersBefore(this.convertFromJson(element.getHeadersBefore()));
        sessionElement.headersAfter(this.convertFromJson(element.getHeadersAfter()));
        sessionElement.propertiesBefore(this.convertPropertiesFromJson(element.getPropertiesBefore()));
        sessionElement.propertiesAfter(this.convertPropertiesFromJson(element.getPropertiesAfter()));
        return sessionElement.build();
    }

    @Override
    public SessionElementElastic toSessionElementElastic(SessionElement element, Session session) {
        if (element == null && session == null) {
            return null;
        }
        SessionElementElastic.SessionElementElasticBuilder<?, ?> sessionElementElastic = SessionElementElastic.builder();
        if (element != null) {
            sessionElementElastic.id(element.getElementId());
            sessionElementElastic.camelElementName(element.getCamelName());
            sessionElementElastic.prevElementId(element.getPreviousElement());
            sessionElementElastic.parentElementId(element.getParentElement());
            sessionElementElastic.started(element.getStarted());
            sessionElementElastic.finished(element.getFinished());
            sessionElementElastic.duration(element.getDuration());
            sessionElementElastic.syncDuration(element.getSyncDuration());
            sessionElementElastic.executionStatus(element.getExecutionStatus());
            sessionElementElastic.sessionId(element.getSessionId());
            sessionElementElastic.actualElementChainId(element.getActualElementChainId());
            sessionElementElastic.elementName(element.getElementName());
            sessionElementElastic.bodyBefore(element.getBodyBefore());
            sessionElementElastic.bodyAfter(element.getBodyAfter());
            sessionElementElastic.contextBefore(this.convertMapToJson(element.getContextBefore()));
            sessionElementElastic.contextAfter(this.convertMapToJson(element.getContextAfter()));
            sessionElementElastic.exceptionInfo(element.getExceptionInfo());
        }
        if (session != null) {
            sessionElementElastic.sessionStarted(session.getStarted());
            sessionElementElastic.sessionFinished(session.getFinished());
            sessionElementElastic.sessionDuration(session.getDuration());
            sessionElementElastic.sessionSyncDuration(session.getSyncDuration());
            sessionElementElastic.sessionExecutionStatus(session.getExecutionStatus());
            sessionElementElastic.chainName(session.getChainName());
            sessionElementElastic.importedSession(session.isImportedSession());
            sessionElementElastic.chainId(session.getChainId());
            sessionElementElastic.domain(session.getDomain());
            sessionElementElastic.engineAddress(session.getEngineAddress());
            sessionElementElastic.loggingLevel(session.getLoggingLevel());
            sessionElementElastic.snapshotName(session.getSnapshotName());
            sessionElementElastic.correlationId(session.getCorrelationId());
            sessionElementElastic.parentSessionId(session.getParentSessionId());
        }
        sessionElementElastic.headersBefore(this.convertMapToJson(element.getHeadersBefore()));
        sessionElementElastic.headersAfter(this.convertMapToJson(element.getHeadersAfter()));
        sessionElementElastic.propertiesBefore(this.convertSessionElementPropertyMapToJson(element.getPropertiesBefore()));
        sessionElementElastic.propertiesAfter(this.convertSessionElementPropertyMapToJson(element.getPropertiesAfter()));
        sessionElementElastic.chainElementId(null);
        return sessionElementElastic.build();
    }
}

