/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.service.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.kubernetes.client.openapi.models.V1Secret;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.qubership.integration.platform.variables.management.rest.exception.SecuredVariablesException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class KubeSecretSerializer
extends StdSerializer<V1Secret> {
    private static final Logger log = LoggerFactory.getLogger(KubeSecretSerializer.class);
    private final ObjectMapper objectMapper;

    @Autowired
    public KubeSecretSerializer(@Qualifier(value="primaryObjectMapper") ObjectMapper objectMapper) {
        this(null, objectMapper);
    }

    public KubeSecretSerializer(Class<V1Secret> t, @Qualifier(value="primaryObjectMapper") ObjectMapper objectMapper) {
        super(t);
        this.objectMapper = objectMapper;
    }

    public void serialize(V1Secret secret, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
        jsonGenerator.writeStartObject();
        if (secret.getKind() != null) {
            jsonGenerator.writeStringField("kind", secret.getKind());
        }
        if (secret.getApiVersion() != null) {
            jsonGenerator.writeStringField("apiVersion", secret.getApiVersion());
        }
        if (secret.getType() != null) {
            jsonGenerator.writeStringField("type", secret.getType());
        }
        if (secret.getImmutable() != null) {
            jsonGenerator.writeBooleanField("immutable", secret.getImmutable().booleanValue());
        }
        if (secret.getMetadata() != null) {
            jsonGenerator.writeFieldName("metadata");
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("name", secret.getMetadata().getName());
            if (secret.getMetadata().getLabels() != null) {
                jsonGenerator.writeObjectField("labels", (Object)secret.getMetadata().getLabels());
            }
            jsonGenerator.writeEndObject();
        }
        if (secret.getData() != null) {
            this.writeSecuredVariablesData(jsonGenerator, secret.getData());
        }
        jsonGenerator.writeEndObject();
    }

    private void writeSecuredVariablesData(JsonGenerator jsonGenerator, Map<String, byte[]> data) throws IOException {
        if (MapUtils.isEmpty(data)) {
            return;
        }
        jsonGenerator.writeFieldName("stringData");
        jsonGenerator.writeStartObject();
        for (Map.Entry<String, byte[]> dataEntry : data.entrySet()) {
            String serializedVariables;
            try {
                Map variables = (Map)this.objectMapper.readValue(new String(dataEntry.getValue()), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                variables.replaceAll((key, value) -> this.composeHelmChartExpressionFromKey(key));
                serializedVariables = this.objectMapper.writeValueAsString((Object)variables);
            }
            catch (IOException e) {
                log.error("Can't deserialize secured variables for tenant: {}", (Object)dataEntry.getKey(), (Object)e);
                throw new SecuredVariablesException("Can't deserialize secured variables for tenant: " + dataEntry.getKey(), (Throwable)e);
            }
            jsonGenerator.writeString(serializedVariables);
        }
        jsonGenerator.writeEndObject();
    }

    private String composeHelmChartExpressionFromKey(String key) {
        return "{{ .Values.<" + key.replaceAll("[.\\-]|(?<=[a-z])([A-Z])(?=[a-z]*)", "_$1").toUpperCase() + "> }}";
    }
}

