/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.configuration.datasource;

import jakarta.annotation.PostConstruct;
import java.util.List;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.configuration.ClassicConfiguration;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.migration.JavaMigration;
import org.qubership.integration.platform.variables.management.configuration.datasource.PersistenceAutoConfiguration;
import org.qubership.integration.platform.variables.management.configuration.datasource.properties.FlywayConfigProperties;
import org.qubership.integration.platform.variables.management.db.migration.postrgesql.configs.ConfigsJavaMigration;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

@AutoConfiguration
@ConditionalOnBean(value={PersistenceAutoConfiguration.class})
@EnableConfigurationProperties(value={FlywayConfigProperties.class})
public class FlywayAutoInitializer {
    private final DataSource configsDataSource;
    private final FlywayConfigProperties properties;
    private final List<ConfigsJavaMigration> configsJavaMigrationList;

    public FlywayAutoInitializer(@Qualifier(value="configsDataSource") DataSource configsDataSource, FlywayConfigProperties properties, List<ConfigsJavaMigration> configsJavaMigrationList) {
        this.configsDataSource = configsDataSource;
        this.properties = properties;
        this.configsJavaMigrationList = configsJavaMigrationList;
    }

    @PostConstruct
    public void migrate() {
        ClassicConfiguration configsConfig = this.properties.getConfig("configs-datasource");
        configsConfig.setDataSource(this.configsDataSource);
        configsConfig.setJavaMigrations(this.configsJavaMigrationList.toArray(new JavaMigration[0]));
        new Flyway((Configuration)configsConfig).migrate();
    }
}

