/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.scheduler;

import org.qubership.integration.platform.variables.management.service.ActionsLogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class TasksScheduler {
    private static final Logger log = LoggerFactory.getLogger(TasksScheduler.class);
    private final ActionsLogService actionsLogService;
    @Value(value="${qip.actions-log.cleanup.interval}")
    private String actionLogInterval;

    public TasksScheduler(ActionsLogService actionsLogService) {
        this.actionsLogService = actionsLogService;
    }

    @Scheduled(cron="${qip.actions-log.cleanup.cron}")
    public void cleanupActionsLog() {
        this.actionsLogService.deleteAllOldRecordsByInterval(this.actionLogInterval);
        log.info("Remove old records from actions log table");
    }
}

