/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.configuration.datasource;

import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.qubership.integration.platform.variables.management.configuration.datasource.properties.HikariConfigProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

@AutoConfiguration
@ConditionalOnMissingBean(value={DataSource.class}, name={"configsDataSource"})
@EnableConfigurationProperties(value={HikariConfigProperties.class})
@EnableJpaRepositories(basePackages={"org.qubership.integration.platform.variables.management.persistence.configs.repository"})
public class PersistenceAutoConfiguration {
    private final HikariConfigProperties properties;

    @Autowired
    public PersistenceAutoConfiguration(HikariConfigProperties properties) {
        this.properties = properties;
    }

    @Primary
    @Bean(value={"configsDataSource"})
    public DataSource configsDataSource() {
        return new HikariDataSource(this.properties.getDatasource("configs-datasource"));
    }
}

