/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.consul;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.integration.platform.variables.management.consul.ConsulException;
import org.qubership.integration.platform.variables.management.consul.KVNotFoundException;
import org.qubership.integration.platform.variables.management.consul.TxnConflictException;
import org.qubership.integration.platform.variables.management.model.consul.txn.KVResponse;
import org.qubership.integration.platform.variables.management.model.consul.txn.KeyResponse;
import org.qubership.integration.platform.variables.management.model.consul.txn.request.TxnKVRequest;
import org.qubership.integration.platform.variables.management.model.consul.txn.request.TxnRequest;
import org.qubership.integration.platform.variables.management.model.consul.txn.request.TxnVerb;
import org.qubership.integration.platform.variables.management.model.consul.txn.response.TxnResponse;
import org.qubership.integration.platform.variables.management.model.consul.txn.response.TxnResponseResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Component
public class ConsulClient {
    private static final Logger log = LoggerFactory.getLogger(ConsulClient.class);
    public static final int MAX_TXN_SIZE = 64;
    public static final String CONSUL_TOKEN_HEADER = "X-Consul-Token";
    public static final String CONSUL_INDEX_HEADER = "X-Consul-Index";
    public static final String CONSUL_KV_PATH = "/v1/kv";
    public static final String CONSUL_TXN_PATH = "/v1/txn";
    public static final String CONSUL_KV_QUERY_PARAMS = "?recurse={recurse}&index={index}&wait={wait}";
    public static final String CONSUL_KV_DELETE_PARAMS = "?recurse={recurse}";
    private final String consulUrl;
    @Value(value="${consul.token}")
    private String consulToken;
    private final RestTemplate restTemplate;

    @Autowired
    public ConsulClient(@Qualifier(value="restTemplateMS") RestTemplate restTemplate, @Value(value="${consul.url}") String consulUrl) {
        this.restTemplate = restTemplate;
        this.consulUrl = StringUtils.strip((String)consulUrl, (String)"/");
    }

    public List<KeyResponse> getKV(String key, boolean recurse) throws KVNotFoundException {
        return (List)this.waitForKVChanges(key, recurse, 0L, "0").getRight();
    }

    public List<KVResponse> getKVsInTransaction(List<String> keys) throws ConsulException {
        return this.doTxnBatchedRequest(keys.stream().map(key -> new TxnRequest(TxnKVRequest.builder().verb(TxnVerb.GET).key(key).build())).toList()).getResults().stream().map(TxnResponseResult::getKv).toList();
    }

    public void createOrUpdateKV(String key, Object value) {
        HttpEntity entity = new HttpEntity(value, (MultiValueMap)this.buildCommonHeaders());
        ResponseEntity response = this.restTemplate.exchange(this.consulUrl + CONSUL_KV_PATH + key, HttpMethod.PUT, entity, String.class, new Object[0]);
        if (response.getStatusCode() != HttpStatus.OK) {
            log.error("Failed to create or update KV in consul, code: {}, body: {}", (Object)response.getStatusCode(), response.getBody());
            throw new RuntimeException("Failed to create or update KV in consul, response with non 2xx code");
        }
        if (!"true".equalsIgnoreCase((String)response.getBody())) {
            throw new RuntimeException("Failed update/create KV in consul, response: " + String.valueOf(response));
        }
    }

    public void createOrUpdateKVsInTransaction(Map<String, String> map) {
        this.doTxnBatchedRequest(map.entrySet().stream().map(entry -> new TxnRequest(TxnKVRequest.builder().verb(TxnVerb.SET).key((String)entry.getKey()).value((String)entry.getValue()).build())).toList());
    }

    public void deleteKV(String key, boolean recurse) {
        HttpEntity entity = new HttpEntity((MultiValueMap)this.buildCommonHeaders());
        ResponseEntity response = this.restTemplate.exchange(this.consulUrl + CONSUL_KV_PATH + key + CONSUL_KV_DELETE_PARAMS, HttpMethod.DELETE, entity, String.class, Map.of("recurse", recurse));
        if (response.getStatusCode() != HttpStatus.OK) {
            log.error("Failed to remove KEY in consul, code: {}, body: {}", (Object)response.getStatusCode(), response.getBody());
            throw new RuntimeException("Failed to remove KEY in consul, response with non 2xx code");
        }
        if (!"true".equalsIgnoreCase((String)response.getBody())) {
            throw new RuntimeException("Failed remove KEY in consul, response: " + String.valueOf(response));
        }
    }

    public void deleteKVsInTransaction(List<String> keys) {
        this.doTxnBatchedRequest(keys.stream().map(key -> new TxnRequest(TxnKVRequest.builder().verb(TxnVerb.DELETE).key(key).build())).toList());
    }

    private TxnResponse doTxnBatchedRequest(List<TxnRequest> request) throws ConsulException {
        if (request.size() <= 64) {
            return this.doTxnRequest(request);
        }
        TxnResponse result = new TxnResponse();
        for (List txnRequests : ListUtils.partition(request, (int)64)) {
            result.merge(this.doTxnRequest(txnRequests));
        }
        return result;
    }

    private TxnResponse doTxnRequest(List<TxnRequest> request) throws ConsulException {
        ResponseEntity response = null;
        try {
            HttpEntity entity = new HttpEntity(request, (MultiValueMap)this.buildCommonHeaders());
            response = this.restTemplate.exchange(this.consulUrl + CONSUL_TXN_PATH, HttpMethod.PUT, entity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            if (response.getStatusCode() != HttpStatus.OK) {
                log.error("Failed to complete txn consul request, code: {}, body: {}", (Object)response.getStatusCode(), response.getBody());
                throw new RuntimeException("Failed to complete txn consul request, response with non 200 code");
            }
            if (((TxnResponse)response.getBody()).getErrors() != null) {
                throw new RuntimeException("Failed to complete txn consul request, response have errors");
            }
            return (TxnResponse)response.getBody();
        }
        catch (HttpClientErrorException hcee) {
            if (hcee.getStatusCode() == HttpStatus.CONFLICT) {
                log.error("Consul txn request failed with code 409 conflict: {}", (Object)hcee.getMessage());
                throw new TxnConflictException("Consul txn request failed with code 409 conflict", (Throwable)hcee);
            }
            log.error("Consul txn request failed with http error", (Throwable)hcee);
            throw new ConsulException("Consul txn request failed with http error", (Throwable)hcee);
        }
        catch (Exception e) {
            Object errorMessage = "Consul txn request failed";
            if (response != null && response.getBody() != null && ((TxnResponse)response.getBody()).getErrors() != null) {
                errorMessage = (String)errorMessage + " , response errors: " + String.valueOf(((TxnResponse)response.getBody()).getErrors());
            }
            log.error((String)errorMessage, (Throwable)e);
            throw new ConsulException("Consul txn request failed", (Throwable)e);
        }
    }

    public Pair<Long, List<KeyResponse>> waitForKVChanges(String key, boolean recurse, long index, String waitTimeout) throws KVNotFoundException {
        HttpEntity entity = new HttpEntity((MultiValueMap)this.buildCommonHeaders());
        try {
            ResponseEntity response = this.restTemplate.exchange(this.consulUrl + CONSUL_KV_PATH + key + CONSUL_KV_QUERY_PARAMS, HttpMethod.GET, entity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, Map.of("recurse", recurse, "index", index, "wait", waitTimeout));
            if (response.getStatusCode() != HttpStatus.OK) {
                log.error("Failed to get KV from consul, code: {}, body: {}", (Object)response.getStatusCode(), response.getBody());
                throw new RuntimeException("Failed to get KV from consul, response with non 200 code");
            }
            return Pair.of((Object)Long.parseLong((String)response.getHeaders().get((Object)CONSUL_INDEX_HEADER).get(0)), response.getBody() == null ? Collections.emptyList() : (List)response.getBody());
        }
        catch (HttpClientErrorException hcee) {
            if (hcee.getStatusCode() == HttpStatus.NOT_FOUND) {
                throw new KVNotFoundException("KV not present in consul");
            }
            throw hcee;
        }
    }

    private HttpHeaders buildCommonHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set(CONSUL_TOKEN_HEADER, this.consulToken);
        return headers;
    }
}

