/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.service.exportimport.instructions.mapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.qubership.integration.platform.variables.management.model.exportimport.instructions.CommonVariablesImportInstructionsConfig;
import org.qubership.integration.platform.variables.management.model.exportimport.instructions.ImportInstructionAction;
import org.qubership.integration.platform.variables.management.model.exportimport.instructions.ImportInstructionsConfig;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.exportimport.instructions.ImportInstruction;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.exportimport.instructions.ImportInstructionLabel;
import org.qubership.integration.platform.variables.management.rest.v1.dto.variables.instructions.ImportInstructionDTO;
import org.qubership.integration.platform.variables.management.rest.v1.dto.variables.instructions.ImportInstructionsDTO;
import org.springframework.stereotype.Component;

@Component
public class ImportInstructionsMapper {
    public ImportInstructionsConfig asConfig(List<ImportInstruction> importInstructions) {
        HashSet<String> delete = new HashSet<String>();
        HashSet<String> ignore = new HashSet<String>();
        for (ImportInstruction importInstruction : importInstructions) {
            if (importInstruction.getAction() == ImportInstructionAction.DELETE) {
                delete.add(importInstruction.getId());
                continue;
            }
            if (importInstruction.getAction() != ImportInstructionAction.IGNORE) continue;
            ignore.add(importInstruction.getId());
        }
        return ImportInstructionsConfig.builder().delete(delete).ignore(ignore).build();
    }

    public List<ImportInstruction> asEntities(CommonVariablesImportInstructionsConfig commonVariablesImportInstructionsConfig) {
        ImportInstructionsConfig importInstructionsConfig = commonVariablesImportInstructionsConfig.getCommonVariables();
        if (importInstructionsConfig == null) {
            return Collections.emptyList();
        }
        ArrayList<ImportInstruction> importInstructions = new ArrayList<ImportInstruction>();
        for (String id : importInstructionsConfig.getIgnore()) {
            ImportInstruction importInstruction = ImportInstruction.builder().id(id).action(ImportInstructionAction.IGNORE).build();
            if (CollectionUtils.isNotEmpty((Collection)commonVariablesImportInstructionsConfig.getLabels())) {
                importInstruction.setLabels(commonVariablesImportInstructionsConfig.getLabels().stream().map(labelName -> ImportInstructionLabel.builder().name(labelName).importInstruction(importInstruction).build()).collect(Collectors.toList()));
            }
            importInstructions.add(importInstruction);
        }
        return importInstructions;
    }

    public ImportInstructionsDTO asDto(List<ImportInstruction> importInstructions) {
        HashSet<ImportInstructionDTO> variablesToDelete = new HashSet<ImportInstructionDTO>();
        HashSet<ImportInstructionDTO> variablesToIgnore = new HashSet<ImportInstructionDTO>();
        for (ImportInstruction importInstruction : importInstructions) {
            if (ImportInstructionAction.DELETE.equals((Object)importInstruction.getAction())) {
                variablesToDelete.add(this.entityToDto(importInstruction));
                continue;
            }
            if (!ImportInstructionAction.IGNORE.equals((Object)importInstruction.getAction())) continue;
            variablesToIgnore.add(this.entityToDto(importInstruction));
        }
        return ImportInstructionsDTO.builder().delete(variablesToDelete).ignore(variablesToIgnore).build();
    }

    public ImportInstructionDTO entityToDto(ImportInstruction importInstruction) {
        Long modifiedWhen = importInstruction.getModifiedWhen() != null ? Long.valueOf(importInstruction.getModifiedWhen().getTime()) : null;
        Set labels = CollectionUtils.isEmpty((Collection)importInstruction.getLabels()) ? Collections.emptySet() : importInstruction.getLabels().stream().map(ImportInstructionLabel::getName).collect(Collectors.toSet());
        return ImportInstructionDTO.builder().id(importInstruction.getId()).labels(labels).modifiedWhen(modifiedWhen).preview(modifiedWhen == null).build();
    }
}

