/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.configuration;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.kubernetes.client.openapi.models.V1Secret;
import org.qubership.integration.platform.variables.management.service.serializer.KubeSecretSerializer;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

@AutoConfiguration
public class MapperAutoConfiguration {
    @Bean
    @Primary
    @ConditionalOnProperty(prefix="app", name={"prefix"}, havingValue="qip")
    public ObjectMapper objectMapper() {
        return this.qipPrimaryObjectMapper();
    }

    @Bean(value={"primaryObjectMapper"})
    public ObjectMapper qipPrimaryObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.disable(new MapperFeature[]{MapperFeature.DEFAULT_VIEW_INCLUSION});
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        objectMapper.enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS});
        objectMapper.setFilterProvider((FilterProvider)new SimpleFilterProvider().setFailOnUnknownId(false));
        return objectMapper;
    }

    @Bean(value={"objectMapperWithSorting"})
    public ObjectMapper objectMapperWithSorting() {
        ObjectMapper objectMapper = this.qipPrimaryObjectMapper();
        objectMapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
        return objectMapper;
    }

    @Bean(value={"yamlMapper"})
    public YAMLMapper yamlMapper(KubeSecretSerializer kubeSecretSerializer) {
        YAMLMapper yamlMapper = new YAMLMapper();
        SimpleModule serializeModule = new SimpleModule();
        serializeModule.addSerializer(V1Secret.class, (JsonSerializer)kubeSecretSerializer);
        yamlMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        yamlMapper.registerModule((Module)serializeModule);
        yamlMapper.setFilterProvider((FilterProvider)new SimpleFilterProvider().setFailOnUnknownId(false));
        yamlMapper.enable(YAMLGenerator.Feature.MINIMIZE_QUOTES);
        yamlMapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES});
        return yamlMapper;
    }

    @Bean(value={"yamlImportExportMapper"})
    public YAMLMapper yamlImportExportMapper() {
        String[] excludedFields = new String[]{"createdWhen", "modifiedWhen", "createdBy", "modifiedBy"};
        YAMLMapper yamlMapper = new YAMLMapper();
        SimpleModule serializeModule = new SimpleModule();
        yamlMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        yamlMapper.registerModule((Module)serializeModule);
        SimpleFilterProvider simpleFilterProvider = new SimpleFilterProvider().setFailOnUnknownId(false);
        simpleFilterProvider.addFilter("commonVariableFilter", SimpleBeanPropertyFilter.serializeAllExcept((String[])excludedFields));
        yamlMapper.setFilterProvider((FilterProvider)simpleFilterProvider);
        yamlMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return yamlMapper;
    }
}

