/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.model.consul.txn;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.annotation.Nullable;

public class KVResponse {
    @JsonProperty(value="Key")
    private String key;
    @Nullable
    @JsonProperty(value="Value")
    private String value;

    public String getDecodedValue() {
        return this.value == null ? null : new String(Base64.getDecoder().decode(this.value), StandardCharsets.UTF_8);
    }

    protected KVResponse(KVResponseBuilder<?, ?> b) {
        this.key = b.key;
        this.value = b.value;
    }

    public static KVResponseBuilder<?, ?> builder() {
        return new KVResponseBuilderImpl();
    }

    public String getKey() {
        return this.key;
    }

    @Nullable
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="Key")
    public void setKey(String key) {
        this.key = key;
    }

    @JsonProperty(value="Value")
    public void setValue(@Nullable String value) {
        this.value = value;
    }

    public KVResponse() {
    }

    public KVResponse(String key, @Nullable String value) {
        this.key = key;
        this.value = value;
    }

    public static abstract class KVResponseBuilder<C extends KVResponse, B extends KVResponseBuilder<C, B>> {
        private String key;
        private String value;

        @JsonProperty(value="Key")
        public B key(String key) {
            this.key = key;
            return this.self();
        }

        @JsonProperty(value="Value")
        public B value(@Nullable String value) {
            this.value = value;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "KVResponse.KVResponseBuilder(key=" + this.key + ", value=" + this.value + ")";
        }
    }

    private static final class KVResponseBuilderImpl
    extends KVResponseBuilder<KVResponse, KVResponseBuilderImpl> {
        private KVResponseBuilderImpl() {
        }

        @Override
        protected KVResponseBuilderImpl self() {
            return this;
        }

        @Override
        public KVResponse build() {
            return new KVResponse(this);
        }
    }
}

