/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.model.consul.txn.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Base64;
import javax.annotation.Nullable;
import org.qubership.integration.platform.variables.management.model.consul.txn.request.TxnVerb;

public class TxnKVRequest {
    @JsonProperty(value="Verb")
    private TxnVerb verb;
    @JsonProperty(value="Key")
    private String key;
    @Nullable
    @JsonProperty(value="Value")
    private String value;

    public TxnKVRequest(TxnVerb verb, String key, @Nullable String value) {
        this.verb = verb;
        this.key = key;
        this.setValue(value);
    }

    public void setValue(@Nullable String value) {
        this.value = value != null ? Base64.getEncoder().encodeToString(value.getBytes()) : null;
    }

    public static TxnKVRequestBuilder builder() {
        return new TxnKVRequestBuilder();
    }

    public TxnVerb getVerb() {
        return this.verb;
    }

    public String getKey() {
        return this.key;
    }

    @Nullable
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="Verb")
    public void setVerb(TxnVerb verb) {
        this.verb = verb;
    }

    @JsonProperty(value="Key")
    public void setKey(String key) {
        this.key = key;
    }

    public TxnKVRequest() {
    }

    public static class TxnKVRequestBuilder {
        private TxnVerb verb;
        private String key;
        private String value;

        TxnKVRequestBuilder() {
        }

        @JsonProperty(value="Verb")
        public TxnKVRequestBuilder verb(TxnVerb verb) {
            this.verb = verb;
            return this;
        }

        @JsonProperty(value="Key")
        public TxnKVRequestBuilder key(String key) {
            this.key = key;
            return this;
        }

        @JsonProperty(value="Value")
        public TxnKVRequestBuilder value(@Nullable String value) {
            this.value = value;
            return this;
        }

        public TxnKVRequest build() {
            return new TxnKVRequest(this.verb, this.key, this.value);
        }

        public String toString() {
            return "TxnKVRequest.TxnKVRequestBuilder(verb=" + String.valueOf((Object)this.verb) + ", key=" + this.key + ", value=" + this.value + ")";
        }
    }
}

