/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.rest.v1.dto.variables.instructions;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import org.qubership.integration.platform.variables.management.validation.constraint.NotStartOrEndWithSpace;

@Schema(description="Import instruction create/update object")
public class ImportInstructionRequest {
    @Schema(description="Import instruction id")
    @NotStartOrEndWithSpace(message="must not be null and must not start or end with a space")
    @Pattern(regexp="^[-._a-zA-Z0-9]+$", message="does not match \"{regexp}\"")
    private @NotStartOrEndWithSpace(message="must not be null and must not start or end with a space") @Pattern(regexp="^[-._a-zA-Z0-9]+$", message="does not match \"{regexp}\"") String id;
    @Schema(description="Import instruction action", allowableValues={"IGNORE"})
    @NotNull(message="must not be null")
    @Pattern(regexp="IGNORE", message="must be IGNORE")
    private @NotNull(message="must not be null") @Pattern(regexp="IGNORE", message="must be IGNORE") String action;

    protected ImportInstructionRequest(ImportInstructionRequestBuilder<?, ?> b) {
        this.id = b.id;
        this.action = b.action;
    }

    public static ImportInstructionRequestBuilder<?, ?> builder() {
        return new ImportInstructionRequestBuilderImpl();
    }

    public String getId() {
        return this.id;
    }

    public String getAction() {
        return this.action;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public ImportInstructionRequest() {
    }

    public String toString() {
        return "ImportInstructionRequest(id=" + this.getId() + ", action=" + this.getAction() + ")";
    }

    public static abstract class ImportInstructionRequestBuilder<C extends ImportInstructionRequest, B extends ImportInstructionRequestBuilder<C, B>> {
        private String id;
        private String action;

        public B id(String id) {
            this.id = id;
            return this.self();
        }

        public B action(String action) {
            this.action = action;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "ImportInstructionRequest.ImportInstructionRequestBuilder(id=" + this.id + ", action=" + this.action + ")";
        }
    }

    private static final class ImportInstructionRequestBuilderImpl
    extends ImportInstructionRequestBuilder<ImportInstructionRequest, ImportInstructionRequestBuilderImpl> {
        private ImportInstructionRequestBuilderImpl() {
        }

        @Override
        protected ImportInstructionRequestBuilderImpl self() {
            return this;
        }

        @Override
        public ImportInstructionRequest build() {
            return new ImportInstructionRequest(this);
        }
    }
}

