/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.service;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.actionlog.ActionLog;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.actionlog.EntityType;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.user.User;
import org.qubership.integration.platform.variables.management.persistence.configs.repository.actionlog.ActionLogRepository;
import org.qubership.integration.platform.variables.management.rest.exception.InvalidEnumConstantException;
import org.qubership.integration.platform.variables.management.rest.v1.dto.actionlog.ActionLogSearchCriteria;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.AuditorAware;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActionsLogService {
    private static final Logger log = LoggerFactory.getLogger(ActionsLogService.class);
    private final ActionLogRepository actionLogRepository;
    private final AuditorAware<User> auditor;
    private final BlockingQueue<ActionLog> queue = new LinkedBlockingQueue<ActionLog>();

    @Autowired
    public ActionsLogService(ActionLogRepository actionLogRepository, AuditorAware<User> auditor) {
        this.actionLogRepository = actionLogRepository;
        this.auditor = auditor;
        new ActionWriterThread(actionLogRepository, this.queue).start();
    }

    public Pair<Long, List<ActionLog>> findBySearchRequest(ActionLogSearchCriteria request) {
        try {
            List actionLogsByFilter = this.actionLogRepository.findActionLogsByFilter(request.getOffsetTime(), request.getRangeTime(), request.getFilters());
            long recordsAfterRange = this.actionLogRepository.getRecordsCountAfterTime(new Timestamp(request.getOffsetTime().getTime() - request.getRangeTime()), request.getFilters());
            return Pair.of((Object)recordsAfterRange, (Object)actionLogsByFilter);
        }
        catch (InvalidEnumConstantException e) {
            log.debug(e.getMessage());
            return Pair.of((Object)0L, Collections.emptyList());
        }
    }

    public List<ActionLog> findAllByActionTimeBetween(Timestamp actionTimeFrom, Timestamp actionTimeTo) {
        return this.actionLogRepository.findAllByActionTimeBetween(actionTimeFrom, actionTimeTo);
    }

    public boolean logAction(ActionLog action) {
        this.injectCurrentUser(action);
        this.injectRequestId(action);
        try {
            if (!this.queue.offer(action)) {
                log.error("Queue of actions is full, element is not added, {}", (Object)this.maskSecretName(action));
                return false;
            }
            this.consoleLogAction(this.maskSecretName(action));
            return true;
        }
        catch (Exception e) {
            log.error("Failed to save action log to database: {}", (Object)this.maskSecretName(action), (Object)e);
            return false;
        }
    }

    private void injectRequestId(ActionLog action) {
        action.setRequestId(MDC.get((String)"requestId"));
    }

    private void injectCurrentUser(ActionLog action) {
        this.auditor.getCurrentAuditor().ifPresent(action::setUser);
    }

    @Transactional
    public void deleteAllOldRecordsByInterval(String olderThan) {
        this.actionLogRepository.deleteAllOldRecordsByInterval(olderThan);
    }

    private void consoleLogAction(ActionLog action) {
        MDC.put((String)"logType", (String)"audit");
        String actionOperationName = action.getOperation() != null ? action.getOperation().name() : "-";
        String entityTypeName = action.getEntityType() != null ? action.getEntityType().name() : "-";
        String entityNameDescriptionString = action.getEntityName() != null ? " with name ".concat(action.getEntityName()) : "";
        String entityIdDescriptionString = action.getEntityId() != null ? " with id: ".concat(action.getEntityId()) : "";
        String parentTypeName = action.getParentType() != null ? " under parent entity ".concat(action.getParentType().name()) : "-";
        String parentNameDescriptionString = action.getParentName() != null ? " with name ".concat(action.getParentName()) : "";
        String parentIdDescriptionString = action.getParentId() != null ? " with id: ".concat(action.getParentId()) : "";
        String userDescriptionString = action.getUser().getUsername() != null ? " performed by user ".concat(action.getUser().getUsername()) : "";
        userDescriptionString = action.getUser().getId() != null ? userDescriptionString.concat(" with id: ").concat(action.getUser().getId()) : "";
        log.debug("Action {} for {}{}{}{}{}{}{}", new Object[]{actionOperationName, entityTypeName, entityNameDescriptionString, entityIdDescriptionString, parentTypeName, parentNameDescriptionString, parentIdDescriptionString, userDescriptionString});
        MDC.remove((String)"logType");
    }

    private ActionLog maskSecretName(ActionLog actionLog) {
        if (actionLog.getEntityType() == EntityType.SECRET) {
            actionLog.setEntityName("Secret");
        }
        if (actionLog.getParentType() == EntityType.SECRET) {
            actionLog.setParentName("Secret");
        }
        return actionLog;
    }

    private static class ActionWriterThread
    extends Thread {
        private final ActionLogRepository actionLogRepository;
        private final BlockingQueue<ActionLog> queue;
        private final List<ActionLog> actionsToSave = new ArrayList<ActionLog>();

        public ActionWriterThread(ActionLogRepository actionLogRepository, BlockingQueue<ActionLog> queue) {
            this.actionLogRepository = actionLogRepository;
            this.queue = queue;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    this.actionsToSave.add(this.queue.take());
                }
                catch (InterruptedException ignored) {
                    continue;
                }
                this.queue.drainTo(this.actionsToSave);
                this.trySaveAllActions(this.actionsToSave);
                this.actionsToSave.clear();
            }
        }

        private void trySaveAllActions(Collection<ActionLog> actions) {
            try {
                this.actionLogRepository.saveAll(actions);
            }
            catch (Exception e) {
                log.error("Failed to save actions in database", (Throwable)e);
            }
        }
    }
}

