/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.service.exportimport;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.dhatim.fastexcel.StyleSetter;
import org.dhatim.fastexcel.Workbook;
import org.dhatim.fastexcel.Worksheet;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.actionlog.ActionLog;
import org.qubership.integration.platform.variables.management.service.ActionsLogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActionsLogExportService {
    private static final Logger log = LoggerFactory.getLogger(ActionsLogExportService.class);
    private static final String EXCEL_EXPORT_ERROR = "Failed to create Excel document: ";
    private final ActionsLogService actionsLogService;
    private static final int START_INDEX = 0;
    private static final int ACTION_TIME_INDEX = 0;
    private static final int USERNAME_INDEX = 1;
    private static final int OPERATION_INDEX = 2;
    private static final int ENTITY_ID_INDEX = 3;
    private static final int ENTITY_TYPE_INDEX = 4;
    private static final int ENTITY_NAME_INDEX = 5;
    private static final int PARENT_ID_INDEX = 6;
    private static final int PARENT_NAME_INDEX = 7;
    private static final int REQUEST_ID_INDEX = 8;
    private static final int LAST_INDEX = 8;
    private static final int FONT_SIZE = 11;

    @Autowired
    public ActionsLogExportService(ActionsLogService actionsLogService) {
        this.actionsLogService = actionsLogService;
    }

    public byte[] exportAsExcelDocument(Timestamp actionTimeFrom, Timestamp actionTimeTo) {
        byte[] byArray;
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        try {
            Workbook workbook = new Workbook((OutputStream)fos, "Variables Management", "1.0");
            Worksheet worksheet = workbook.newWorksheet("Actions log");
            this.setHeaderCells(worksheet);
            this.setDataCells(worksheet, actionTimeFrom, actionTimeTo);
            workbook.finish();
            byArray = fos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    fos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(EXCEL_EXPORT_ERROR + e.getMessage());
            }
        }
        fos.close();
        return byArray;
    }

    private void setHeaderCells(Worksheet worksheet) {
        worksheet.value(0, 0, "Action Time");
        worksheet.value(0, 1, "Initiator");
        worksheet.value(0, 2, "Operation");
        worksheet.value(0, 3, "Entity Id");
        worksheet.value(0, 4, "Entity Type");
        worksheet.value(0, 5, "Entity Name");
        worksheet.value(0, 6, "Parent Id");
        worksheet.value(0, 7, "Parent Name");
        worksheet.value(0, 8, "Request Id");
        for (int i = 0; i <= 8; ++i) {
            ((StyleSetter)((StyleSetter)worksheet.style(0, i).fontSize(11)).bold()).set();
        }
    }

    private void setDataCells(Worksheet worksheet, Timestamp actionTimeFrom, Timestamp actionTimeTo) {
        List<ActionLog> actions = this.actionsLogService.findAllByActionTimeBetween(actionTimeFrom, actionTimeTo);
        int actionRowNumber = 0;
        for (ActionLog action : actions) {
            worksheet.value(++actionRowNumber, 0, this.applyFormatterOnTimestamp(action.getActionTime()));
            ((StyleSetter)worksheet.style(actionRowNumber, 0).horizontalAlignment("Left")).set();
            worksheet.value(actionRowNumber, 1, action.getUser().getUsername());
            worksheet.value(actionRowNumber, 2, action.getOperation().name());
            worksheet.value(actionRowNumber, 3, action.getEntityId());
            worksheet.value(actionRowNumber, 4, action.getEntityType().name());
            worksheet.value(actionRowNumber, 5, action.getEntityName());
            worksheet.value(actionRowNumber, 6, action.getParentId());
            worksheet.value(actionRowNumber, 7, action.getParentName());
            worksheet.value(actionRowNumber, 8, action.getRequestId());
        }
    }

    private String applyFormatterOnTimestamp(Timestamp actionTime) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss a z");
        dateFormat.setTimeZone(TimeZone.getTimeZone(ZonedDateTime.now().getZone()));
        return dateFormat.format(new Date(actionTime.getTime()));
    }
}

