/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.service.exportimport.instructions.filter;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.commons.collections4.CollectionUtils;
import org.qubership.integration.platform.variables.management.model.exportimport.instructions.ImportInstructionsFilterColumn;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.enums.filter.FilterCondition;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.exportimport.instructions.ImportInstruction;
import org.qubership.integration.platform.variables.management.rest.v1.dto.instructions.ImportInstructionsFilterRequest;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Component;

@Component
public class ImportInstructionsFilterSpecificationBuilder {
    public Specification<ImportInstruction> buildSearch(List<ImportInstructionsFilterRequest> filters) {
        return this.buildFilter(filters, CriteriaBuilder::or);
    }

    public Specification<ImportInstruction> buildFilter(List<ImportInstructionsFilterRequest> filters) {
        return this.buildFilter(filters, CriteriaBuilder::and);
    }

    private Specification<ImportInstruction> buildFilter(List<ImportInstructionsFilterRequest> filters, BiFunction<CriteriaBuilder, Predicate[], Predicate> predicateAccumulator) {
        return (Specification & Serializable)(root, query, criteriaBuilder) -> {
            query.distinct(true);
            if (CollectionUtils.isEmpty((Collection)filters)) {
                return null;
            }
            Predicate[] predicates = (Predicate[])filters.stream().filter(filter -> !ImportInstructionsFilterColumn.OVERRIDDEN_BY.equals((Object)filter.getFeature())).map(filter -> this.buildPredicate((Root<ImportInstruction>)root, criteriaBuilder, (ImportInstructionsFilterRequest)filter)).toArray(Predicate[]::new);
            return predicates.length > 1 ? (Predicate)predicateAccumulator.apply(criteriaBuilder, predicates) : predicates[0];
        };
    }

    private Predicate buildPredicate(Root<ImportInstruction> root, CriteriaBuilder criteriaBuilder, ImportInstructionsFilterRequest filter) {
        BiFunction<Expression<String>, String, Predicate> conditionPredicateBuilder = this.getPredicateBuilder(criteriaBuilder, filter.getCondition());
        String filterValue = filter.getValue();
        return switch (filter.getFeature()) {
            case ImportInstructionsFilterColumn.ID -> conditionPredicateBuilder.apply((Expression<String>)root.get("id"), filterValue);
            case ImportInstructionsFilterColumn.INSTRUCTION_ACTION -> conditionPredicateBuilder.apply((Expression<String>)root.get("action"), filterValue);
            case ImportInstructionsFilterColumn.LABELS -> {
                boolean negativeLabelFilter;
                Predicate predicate = conditionPredicateBuilder.apply((Expression<String>)this.getJoin(root, "labels").get("name"), filterValue);
                boolean v1 = negativeLabelFilter = filter.getCondition() == FilterCondition.IS_NOT || filter.getCondition() == FilterCondition.DOES_NOT_CONTAIN;
                if (negativeLabelFilter) {
                    yield criteriaBuilder.or((Expression)predicate, (Expression)criteriaBuilder.isNull((Expression)this.getJoin(root, "labels").get("name")));
                }
                yield predicate;
            }
            case ImportInstructionsFilterColumn.MODIFIED_WHEN -> conditionPredicateBuilder.apply((Expression<String>)root.get("modifiedWhen"), filterValue);
            default -> throw new IllegalStateException("Unexpected feature value: " + String.valueOf((Object)filter.getFeature()));
        };
    }

    private BiFunction<Expression<String>, String, Predicate> getPredicateBuilder(CriteriaBuilder criteriaBuilder, FilterCondition condition) {
        return switch (condition) {
            default -> throw new IncompatibleClassChangeError();
            case FilterCondition.IS -> (arg_0, arg_1) -> ((CriteriaBuilder)criteriaBuilder).equal(arg_0, arg_1);
            case FilterCondition.IS_NOT -> (arg_0, arg_1) -> ((CriteriaBuilder)criteriaBuilder).notEqual(arg_0, arg_1);
            case FilterCondition.CONTAINS -> (expression, value) -> criteriaBuilder.like(criteriaBuilder.lower(expression.as(String.class)), criteriaBuilder.lower(criteriaBuilder.literal((Object)("%" + value + "%"))));
            case FilterCondition.DOES_NOT_CONTAIN -> (expression, value) -> criteriaBuilder.notLike(criteriaBuilder.lower(expression.as(String.class)), criteriaBuilder.lower(criteriaBuilder.literal((Object)("%" + value + "%"))));
            case FilterCondition.START_WITH -> (expression, value) -> criteriaBuilder.like(criteriaBuilder.lower(expression.as(String.class)), String.valueOf(value).toLowerCase() + "%");
            case FilterCondition.ENDS_WITH -> (expression, value) -> criteriaBuilder.like(criteriaBuilder.lower(expression.as(String.class)), "%" + String.valueOf(value).toLowerCase());
            case FilterCondition.IN -> (expression, value) -> expression.as(String.class).in(Arrays.asList(String.valueOf(value).split(",")));
            case FilterCondition.NOT_IN -> (expression, value) -> criteriaBuilder.not((Expression)expression.as(String.class).in(Arrays.asList(String.valueOf(value).split(","))));
            case FilterCondition.EMPTY -> (expression, value) -> criteriaBuilder.or((Expression)expression.isNull(), (Expression)criteriaBuilder.equal(expression.as(String.class), (Object)""));
            case FilterCondition.NOT_EMPTY -> (expression, value) -> criteriaBuilder.notEqual(expression.as(String.class), (Object)"");
            case FilterCondition.IS_AFTER -> (expression, value) -> criteriaBuilder.greaterThan(expression.as(Timestamp.class), (Comparable)new Timestamp(Long.parseLong(String.valueOf(value))));
            case FilterCondition.IS_BEFORE -> (expression, value) -> criteriaBuilder.lessThan(expression.as(Timestamp.class), (Comparable)new Timestamp(Long.parseLong(String.valueOf(value))));
            case FilterCondition.IS_WITHIN -> (expression, value) -> {
                String[] range = String.valueOf(value).split(",");
                return criteriaBuilder.between(expression.as(Timestamp.class), (Comparable)new Timestamp(Long.parseLong(String.valueOf(range[0]))), (Comparable)new Timestamp(Long.parseLong(String.valueOf(range[1]))));
            };
        };
    }

    private Join<ImportInstruction, ?> getJoin(Root<ImportInstruction> root, String attributeName) {
        return root.getJoins().stream().filter(join -> join.getAttribute().getName().equals(attributeName)).findAny().orElseGet(() -> root.join(attributeName, JoinType.LEFT));
    }
}

