/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.kubernetes;

import io.kubernetes.client.openapi.ApiCallback;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.models.V1Secret;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.lang.NonNull;

public class SecretUpdateCallback
implements ApiCallback<V1Secret> {
    private final CompletableFuture<Map<String, String>> future;

    public SecretUpdateCallback(@NonNull CompletableFuture<Map<String, String>> future) {
        this.future = future;
    }

    public void onSuccess(V1Secret secret, int statusCode, Map<String, List<String>> responseHeaders) {
        ConcurrentHashMap secretDataMap = new ConcurrentHashMap();
        if (secret.getData() != null) {
            secret.getData().forEach((k, v) -> secretDataMap.put(k, new String((byte[])v)));
        }
        this.future.complete(secretDataMap);
    }

    public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
        this.future.completeExceptionally(e);
    }

    public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {
    }

    public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
    }
}

