/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.rest.v2.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.Pattern;
import org.qubership.integration.platform.variables.management.service.SecretService;
import org.qubership.integration.platform.variables.management.util.ExportImportUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v2/secret"})
@CrossOrigin(origins={"*"})
@Validated
@Tag(name="secret-controller-v-2", description="Secret Controller V2")
public class SecretControllerV2 {
    private static final Logger log = LoggerFactory.getLogger(SecretControllerV2.class);
    private final SecretService secretService;

    public SecretControllerV2(SecretService secretService) {
        this.secretService = secretService;
    }

    @Operation(description="Create new secret")
    @PostMapping(value={"/{secretName}"})
    public ResponseEntity<Void> createSecret(@PathVariable @Pattern(regexp="^[a-z]+[-a-z0-9]*$", message="does not match \"{regexp}\"") @Parameter(description="Name of secret") @Pattern(regexp="^[a-z]+[-a-z0-9]*$", message="does not match \"{regexp}\"") String secretName) {
        log.info("Request to create secret {}", (Object)secretName);
        this.secretService.createSecuredVariablesSecret(secretName);
        return ResponseEntity.ok().build();
    }

    @Operation(description="Get helm template for creating secret on kubernetes as a file")
    @GetMapping(value={"/template/{secretName}"})
    public ResponseEntity<Object> downloadSecretHelmChart(@PathVariable @Parameter(description="Name of secret") String secretName) {
        String secretYaml = this.secretService.getSecretTemplate(secretName);
        return ExportImportUtils.bytesAsResponse((byte[])secretYaml.getBytes(), (String)(secretName + ".yaml"));
    }
}

