/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.rest.v2.controller;

import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Set;
import org.qubership.integration.platform.variables.management.rest.v2.dto.variables.ImportVariablesResult;
import org.qubership.integration.platform.variables.management.service.CommonVariablesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/v2/common-variables"})
@CrossOrigin(origins={"*"})
@Validated
@Tag(name="common-variables-controller-v-2", description="Common Variables Controller V2")
public class CommonVariablesControllerV2 {
    private static final Logger log = LoggerFactory.getLogger(CommonVariablesControllerV2.class);
    private final CommonVariablesService commonVariablesService;

    @Autowired
    public CommonVariablesControllerV2(CommonVariablesService commonVariablesService) {
        this.commonVariablesService = commonVariablesService;
    }

    @PostMapping(value={"/import"})
    public ResponseEntity<ImportVariablesResult> importVariablesInternal(@RequestParam MultipartFile file, @RequestParam(required=false) Set<String> variablesNames) {
        log.info("Request to import common variables");
        ImportVariablesResult importVariablesResult = this.commonVariablesService.importVariables(file, variablesNames);
        return ResponseEntity.ok((Object)importVariablesResult);
    }
}

