/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Pattern;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.qubership.integration.platform.variables.management.rest.v1.dto.StringResponse;
import org.qubership.integration.platform.variables.management.rest.v1.dto.variables.ImportVariableDTO;
import org.qubership.integration.platform.variables.management.rest.v1.dto.variables.ImportVariablePreview;
import org.qubership.integration.platform.variables.management.rest.v1.dto.variables.VariablesFileResponse;
import org.qubership.integration.platform.variables.management.rest.v1.mapper.CommonVariablesMapper;
import org.qubership.integration.platform.variables.management.service.CommonVariablesService;
import org.qubership.integration.platform.variables.management.util.ExportImportUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/v1/common-variables"})
@CrossOrigin(origins={"*"})
@Validated
@Tag(name="common-variables-controller", description="Common Variables Controller")
public class CommonVariablesController {
    private static final Logger log = LoggerFactory.getLogger(CommonVariablesController.class);
    private final CommonVariablesService commonVariablesService;
    private final CommonVariablesMapper commonVariablesMapper;

    @Autowired
    public CommonVariablesController(CommonVariablesService commonVariablesService, CommonVariablesMapper commonVariablesMapper) {
        this.commonVariablesService = commonVariablesService;
        this.commonVariablesMapper = commonVariablesMapper;
    }

    @Operation(description="Get all common variables")
    @GetMapping
    public ResponseEntity<Map<String, String>> getVariables() {
        if (log.isDebugEnabled()) {
            log.debug("Request to get common variables");
        }
        return ResponseEntity.ok((Object)this.commonVariablesService.getVariables());
    }

    @Operation(extensions={@Extension(properties={@ExtensionProperty(name="x-api-kind", value="bwc")})}, description="Add new common variable(s)")
    @PostMapping
    public ResponseEntity<List<String>> addVariables(@Valid @RequestBody @Parameter(description="New common variables as a map of <key, value>") Map<@Pattern(regexp="^[-._a-zA-Z0-9]+$", message="does not match \"{regexp}\"") String, String> variables) {
        log.info("Request to add common variable");
        List body = this.commonVariablesMapper.importAsNames(this.commonVariablesService.addVariables(variables, false));
        return ResponseEntity.ok((Object)body);
    }

    @Operation(extensions={@Extension(properties={@ExtensionProperty(name="x-api-kind", value="bwc")})}, description="Update or add single common variable")
    @PatchMapping(value={"/{name}"})
    public ResponseEntity<StringResponse> updateVariable(@PathVariable @Parameter(description="Name of the variable") String name, @RequestBody(required=false) @Parameter(description="New value of the parameter") String value) {
        log.info("Request to update common variable {}", (Object)name);
        String commonVariable = this.commonVariablesService.addVariable(name, value);
        return ResponseEntity.ok((Object)new StringResponse(commonVariable));
    }

    @Operation(extensions={@Extension(properties={@ExtensionProperty(name="x-api-kind", value="bwc")})}, description="Delete set of variables")
    @DeleteMapping
    public ResponseEntity<Void> deleteVariables(@RequestParam @Parameter(description="Set of variables to remove") List<String> variablesNames) {
        log.info("Request to delete common variables");
        this.commonVariablesService.deleteVariables(variablesNames);
        return ResponseEntity.noContent().build();
    }

    @Operation(description="Export common variables as a file")
    @GetMapping(value={"/export"}, produces={"application/octet-stream"})
    public ResponseEntity<Object> exportVariables(@Valid @RequestParam(required=false) @Parameter(description="List of variables names to export") List<@Pattern(regexp="^[-._a-zA-Z0-9]+$", message="does not match \"{regexp}\"") String> variablesNames, @RequestParam(defaultValue="false") @Parameter(description="Whether response should be in archive") boolean asArchive) {
        log.info("Request to export common variables");
        VariablesFileResponse response = this.commonVariablesService.exportVariables(variablesNames, asArchive);
        if (response == null || response.getContent() == null) {
            return ResponseEntity.noContent().build();
        }
        return ExportImportUtils.bytesAsResponse((byte[])response.getContent(), (String)response.getFileName());
    }

    @Deprecated(since="24.4")
    @Operation(extensions={@Extension(properties={@ExtensionProperty(name="x-api-kind", value="bwc")})}, description="Import common variables from file")
    @PostMapping(value={"/import"})
    public ResponseEntity<List<ImportVariableDTO>> importVariables(@RequestParam @Parameter(description="File to import") MultipartFile file, @Valid @RequestParam(required=false) @Parameter(description="Variables names. If set, only these variables will be imported") Set<@Pattern(regexp="^[-._a-zA-Z0-9]+$", message="does not match \"{regexp}\"") String> variablesNames) {
        log.info("Request to import common variables");
        List importedVariables = this.commonVariablesService.importVariables(file, variablesNames).getVariables();
        return CollectionUtils.isEmpty((Collection)importedVariables) ? ResponseEntity.noContent().build() : ResponseEntity.ok().body((Object)importedVariables);
    }

    @Operation(description="Get common variables from file without saving")
    @PostMapping(value={"/preview"})
    public ResponseEntity<List<ImportVariablePreview>> importPreview(@RequestParam @Parameter(description="File to import") MultipartFile file) {
        log.debug("Request to import common variables preview");
        return ResponseEntity.ok((Object)this.commonVariablesService.importVariablePreview(file));
    }
}

