/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.service;

import org.qubership.integration.platform.variables.management.service.DefaultVariablesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class RestoreVariablesListener {
    private static final Logger log = LoggerFactory.getLogger(RestoreVariablesListener.class);
    private final DefaultVariablesService defaultVariablesService;

    @Autowired
    public RestoreVariablesListener(DefaultVariablesService defaultVariablesService) {
        this.defaultVariablesService = defaultVariablesService;
    }

    @Async
    @EventListener
    public void onApplicationEvent(ApplicationStartedEvent event) {
        try {
            this.defaultVariablesService.restoreVariables();
        }
        catch (Exception e) {
            MDC.put((String)"error_code", (String)"8051");
            log.error("Event Listener execution failed with error: can't to restore variables, listener: {}", (Object)RestoreVariablesListener.class.getName());
            MDC.remove((String)"error_code");
        }
    }
}

