/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.service.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.kubernetes.client.openapi.models.V1Secret;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class KubeSecretSerializer
extends StdSerializer<V1Secret> {
    private static final Logger log = LoggerFactory.getLogger(KubeSecretSerializer.class);
    private static final String TEST_VARIABLE_KEY = "test";

    public KubeSecretSerializer() {
        this(null);
    }

    public KubeSecretSerializer(Class<V1Secret> t) {
        super(t);
    }

    public void serialize(V1Secret secret, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
        jsonGenerator.writeStartObject();
        if (secret.getKind() != null) {
            jsonGenerator.writeStringField("kind", secret.getKind());
        }
        if (secret.getApiVersion() != null) {
            jsonGenerator.writeStringField("apiVersion", secret.getApiVersion());
        }
        if (secret.getType() != null) {
            jsonGenerator.writeStringField("type", secret.getType());
        }
        if (secret.getImmutable() != null) {
            jsonGenerator.writeBooleanField("immutable", secret.getImmutable().booleanValue());
        }
        if (secret.getMetadata() != null) {
            jsonGenerator.writeFieldName("metadata");
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("name", secret.getMetadata().getName());
            if (secret.getMetadata().getLabels() != null) {
                jsonGenerator.writeObjectField("labels", (Object)secret.getMetadata().getLabels());
            }
            jsonGenerator.writeEndObject();
        }
        this.writeSecuredVariablesData(jsonGenerator, secret.getData());
        jsonGenerator.writeEndObject();
    }

    private void writeSecuredVariablesData(JsonGenerator jsonGenerator, Map<String, byte[]> data) throws IOException {
        if (MapUtils.isEmpty(data)) {
            data = new HashMap<String, byte[]>();
            data.put(TEST_VARIABLE_KEY, new byte[0]);
        }
        jsonGenerator.writeFieldName("stringData");
        jsonGenerator.writeStartObject();
        for (String variableKey : data.keySet()) {
            jsonGenerator.writeFieldName(variableKey);
            jsonGenerator.writeString(this.composeHelmChartExpressionFromKey(variableKey));
        }
        jsonGenerator.writeEndObject();
    }

    private String composeHelmChartExpressionFromKey(String key) {
        return "{{ .Values.<" + key.replaceAll("[.\\-]|(?<=[a-z])([A-Z])(?=[a-z]*)", "_$1").toUpperCase() + "> }}";
    }
}

