/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.rest.exception;

import jakarta.persistence.EntityExistsException;
import jakarta.persistence.EntityNotFoundException;
import jakarta.validation.ConstraintViolationException;
import java.sql.Timestamp;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.qubership.integration.platform.variables.management.consul.ConsulException;
import org.qubership.integration.platform.variables.management.consul.TxnConflictException;
import org.qubership.integration.platform.variables.management.kubernetes.KubeApiException;
import org.qubership.integration.platform.variables.management.rest.exception.EmptyVariableFieldException;
import org.qubership.integration.platform.variables.management.rest.exception.ExceptionDTO;
import org.qubership.integration.platform.variables.management.rest.exception.MalformedVariableNameException;
import org.qubership.integration.platform.variables.management.rest.exception.SecuredVariablesException;
import org.qubership.integration.platform.variables.management.rest.exception.SecuredVariablesNotFoundException;
import org.qubership.integration.platform.variables.management.rest.exception.VariablesManagementRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class GlobalExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    private static final String NO_STACKTRACE_AVAILABLE_MESSAGE = "No Stacktrace Available, check the logs for more details";

    @ExceptionHandler
    public ResponseEntity<ExceptionDTO> handleGeneralException(Exception exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)this.getExceptionDTO(exception));
    }

    @ExceptionHandler(value={EntityNotFoundException.class})
    public ResponseEntity<ExceptionDTO> handleEntityNotFound() {
        return ResponseEntity.notFound().build();
    }

    @ExceptionHandler(value={EntityExistsException.class})
    public ResponseEntity<ExceptionDTO> handleEntityExistsException(EntityExistsException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)this.getExceptionDTOWithoutStacktrace((Exception)exception));
    }

    @ExceptionHandler(value={KubeApiException.class})
    public ResponseEntity<ExceptionDTO> handleApiException(VariablesManagementRuntimeException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)this.getExceptionDTO(exception));
    }

    @ExceptionHandler(value={EmptyVariableFieldException.class})
    public ResponseEntity<ExceptionDTO> handleEmptyVariableFieldException(EmptyVariableFieldException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)this.getExceptionDTO(exception));
    }

    @ExceptionHandler(value={MalformedVariableNameException.class})
    public ResponseEntity<ExceptionDTO> handleMalformedVariableNameException(MalformedVariableNameException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)this.getExceptionDTO(exception));
    }

    @ExceptionHandler(value={SecuredVariablesException.class})
    public ResponseEntity<ExceptionDTO> handleSecuredVariablesException(SecuredVariablesException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)this.getExceptionDTO(exception));
    }

    @ExceptionHandler(value={ConsulException.class})
    public ResponseEntity<ExceptionDTO> handleConsulException(ConsulException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)this.getExceptionDTOWithoutStacktrace(exception));
    }

    @ExceptionHandler(value={TxnConflictException.class})
    public ResponseEntity<ExceptionDTO> handleTxnConflictException(TxnConflictException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)this.getExceptionDTOWithoutStacktrace(exception));
    }

    @ExceptionHandler(value={SecuredVariablesNotFoundException.class})
    public ResponseEntity<ExceptionDTO> handleSecuredVariablesNotFoundException(SecuredVariablesNotFoundException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)this.getExceptionDTO(exception));
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public ResponseEntity<ExceptionDTO> handleConstraintViolationException(ConstraintViolationException exception) {
        String errorMessage = exception.getConstraintViolations().stream().map(violation -> violation.getPropertyPath().toString() + " " + violation.getMessage()).collect(Collectors.joining(", ", "Invalid request content: [", "]"));
        ExceptionDTO exceptionDTO = ExceptionDTO.builder().errorMessage(errorMessage).errorDate(new Timestamp(System.currentTimeMillis()).toString()).build();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)exceptionDTO);
    }

    public ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException exception, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        String errorMessage = exception.getBindingResult().getFieldErrors().stream().map(fieldError -> fieldError.getField() + " " + fieldError.getDefaultMessage()).collect(Collectors.joining(", ", "Invalid request content: [", "]"));
        ExceptionDTO exceptionDTO = ExceptionDTO.builder().errorMessage(errorMessage).stacktrace(ExceptionUtils.getStackTrace((Throwable)exception)).errorDate(new Timestamp(System.currentTimeMillis()).toString()).build();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)exceptionDTO);
    }

    protected ResponseEntity<Object> createResponseEntity(@Nullable Object body, HttpHeaders headers, HttpStatusCode statusCode, WebRequest request) {
        if (body instanceof ProblemDetail) {
            ProblemDetail problemDetail = (ProblemDetail)body;
            ExceptionDTO exceptionDTO = ExceptionDTO.builder().errorMessage(problemDetail.getDetail()).stacktrace(NO_STACKTRACE_AVAILABLE_MESSAGE).errorDate(new Timestamp(System.currentTimeMillis()).toString()).build();
            return new ResponseEntity((Object)exceptionDTO, (MultiValueMap)headers, statusCode);
        }
        return super.createResponseEntity(body, headers, statusCode, request);
    }

    private ExceptionDTO getExceptionDTO(Exception exception) {
        String message = exception.getMessage();
        String stacktrace = NO_STACKTRACE_AVAILABLE_MESSAGE;
        if (exception instanceof VariablesManagementRuntimeException) {
            VariablesManagementRuntimeException variablesManagementRuntimeException = (VariablesManagementRuntimeException)exception;
            if (variablesManagementRuntimeException.getOriginalException() != null) {
                stacktrace = ExceptionUtils.getStackTrace((Throwable)variablesManagementRuntimeException.getOriginalException());
            }
        } else {
            stacktrace = ExceptionUtils.getStackTrace((Throwable)exception);
        }
        log.error("An error occurred: {}. Stacktrace: {}", (Object)message, (Object)stacktrace);
        return ExceptionDTO.builder().errorMessage(message).stacktrace(NO_STACKTRACE_AVAILABLE_MESSAGE).errorDate(new Timestamp(System.currentTimeMillis()).toString()).build();
    }

    private ExceptionDTO getExceptionDTOWithoutStacktrace(Exception exception) {
        String message = exception.getMessage();
        return ExceptionDTO.builder().errorMessage(message).errorDate(new Timestamp(System.currentTimeMillis()).toString()).build();
    }
}

