/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.service.exportimport.instructions;

import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.qubership.integration.platform.variables.management.consul.ConsulService;
import org.qubership.integration.platform.variables.management.model.exportimport.instructions.CommonVariablesImportInstructionsConfig;
import org.qubership.integration.platform.variables.management.model.exportimport.instructions.ImportEntityType;
import org.qubership.integration.platform.variables.management.model.exportimport.instructions.ImportInstructionExecutionStatus;
import org.qubership.integration.platform.variables.management.model.exportimport.instructions.ImportInstructionsConfig;
import org.qubership.integration.platform.variables.management.model.exportimport.instructions.ImportInstructionsExecutionResult;
import org.qubership.integration.platform.variables.management.model.exportimport.instructions.ImportInstructionsFilterColumn;
import org.qubership.integration.platform.variables.management.model.exportimport.instructions.PerformInstructionsResult;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.actionlog.ActionLog;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.actionlog.EntityType;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.actionlog.LogOperation;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.enums.filter.FilterCondition;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.exportimport.instructions.ImportInstruction;
import org.qubership.integration.platform.variables.management.persistence.configs.repository.exportimport.ImportInstructionsRepository;
import org.qubership.integration.platform.variables.management.rest.exception.ImportInstructionsExternalException;
import org.qubership.integration.platform.variables.management.rest.v1.dto.instructions.ImportInstructionsFilterRequest;
import org.qubership.integration.platform.variables.management.service.ActionsLogService;
import org.qubership.integration.platform.variables.management.service.exportimport.instructions.filter.ImportInstructionsFilterSpecificationBuilder;
import org.qubership.integration.platform.variables.management.service.exportimport.instructions.mapper.ImportInstructionsMapper;
import org.qubership.integration.platform.variables.management.util.ExportImportUtils;
import org.qubership.integration.platform.variables.management.validation.EntityValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ImportInstructionsService {
    private static final Logger log = LoggerFactory.getLogger(ImportInstructionsService.class);
    private final YAMLMapper yamlMapper;
    private final ImportInstructionsRepository importInstructionsRepository;
    private final ImportInstructionsMapper importInstructionsMapper;
    private final ConsulService consulService;
    private final ImportInstructionsFilterSpecificationBuilder importInstructionsFilterSpecificationBuilder;
    private final EntityValidator entityValidator;
    private final ActionsLogService actionsLogService;

    @Autowired
    public ImportInstructionsService(@Qualifier(value="yamlMapper") YAMLMapper yamlMapper, ImportInstructionsRepository importInstructionsRepository, ImportInstructionsMapper importInstructionsMapper, ConsulService consulService, ImportInstructionsFilterSpecificationBuilder importInstructionsFilterSpecificationBuilder, EntityValidator entityValidator, ActionsLogService actionsLogService) {
        this.yamlMapper = yamlMapper;
        this.importInstructionsRepository = importInstructionsRepository;
        this.importInstructionsMapper = importInstructionsMapper;
        this.consulService = consulService;
        this.importInstructionsFilterSpecificationBuilder = importInstructionsFilterSpecificationBuilder;
        this.entityValidator = entityValidator;
        this.actionsLogService = actionsLogService;
    }

    public List<ImportInstruction> getImportInstructions() {
        return this.importInstructionsRepository.findAll();
    }

    public List<ImportInstruction> getImportInstructions(List<ImportInstructionsFilterRequest> filters) {
        if (this.containsOnlyOverriddenByFilter(filters)) {
            return Collections.emptyList();
        }
        Specification specification = this.importInstructionsFilterSpecificationBuilder.buildFilter(filters);
        return this.importInstructionsRepository.findAll(specification);
    }

    public List<ImportInstruction> searchImportInstructions(String searchCondition) {
        Specification specification = this.importInstructionsFilterSpecificationBuilder.buildSearch(Collections.singletonList(ImportInstructionsFilterRequest.builder().feature(ImportInstructionsFilterColumn.ID).condition(FilterCondition.CONTAINS).value(searchCondition).build()));
        return this.importInstructionsRepository.findAll(specification);
    }

    public ImportInstructionsConfig getImportInstructionsConfig() {
        return this.importInstructionsMapper.asConfig(this.importInstructionsRepository.findAll());
    }

    @Transactional
    public ImportInstruction addImportInstruction(ImportInstruction importInstruction) {
        if (this.importInstructionsRepository.existsById((Object)importInstruction.getId())) {
            log.error("Instruction for {}} already exist", (Object)importInstruction.getId());
            throw new ImportInstructionsExternalException("Instruction for " + importInstruction.getId() + " already exist");
        }
        importInstruction = (ImportInstruction)this.importInstructionsRepository.save((Object)importInstruction);
        this.logAction(importInstruction.getId(), LogOperation.CREATE);
        return importInstruction;
    }

    @Transactional
    public ImportInstruction updateImportInstruction(ImportInstruction importInstruction) {
        if (!this.importInstructionsRepository.existsById((Object)importInstruction.getId())) {
            log.error("Instruction with id {} does not exist", (Object)importInstruction.getId());
            throw new ImportInstructionsExternalException("Instruction with id " + importInstruction.getId() + " does not exist");
        }
        importInstruction = (ImportInstruction)this.importInstructionsRepository.save((Object)importInstruction);
        this.logAction(importInstruction.getId(), LogOperation.UPDATE);
        return importInstruction;
    }

    public void deleteImportInstructionsByIds(List<String> importInstructionsIds) {
        this.importInstructionsRepository.deleteAllById(importInstructionsIds);
        importInstructionsIds.forEach(instructionId -> this.logAction(instructionId, LogOperation.DELETE));
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<ImportInstructionsExecutionResult> uploadImportInstructions(MultipartFile importInstructionsConfigFile, List<String> labels) {
        CommonVariablesImportInstructionsConfig importInstructionsConfig;
        String fileName = importInstructionsConfigFile.getOriginalFilename();
        if (!ExportImportUtils.isYamlFile((String)fileName)) {
            log.error("File {} must have yaml/yml extension", (Object)fileName);
            throw new ImportInstructionsExternalException("File " + fileName + " must have yaml/yml extension");
        }
        try {
            importInstructionsConfig = (CommonVariablesImportInstructionsConfig)this.yamlMapper.readValue(importInstructionsConfigFile.getBytes(), CommonVariablesImportInstructionsConfig.class);
        }
        catch (IOException e) {
            log.error("Unable to parse import instructions config file: {}", (Object)fileName);
            throw new ImportInstructionsExternalException("Unable to parse import instructions config file: " + fileName, (Throwable)e);
        }
        importInstructionsConfig.setLabels(labels);
        this.entityValidator.validate((Object)importInstructionsConfig);
        List results = this.performVariableDeleteInstructions(importInstructionsConfig);
        List importInstructions = this.importInstructionsRepository.saveAll((Iterable)this.importInstructionsMapper.asEntities(importInstructionsConfig));
        importInstructions.forEach(importInstruction -> this.logAction(importInstruction.getId(), LogOperation.CREATE_OR_UPDATE));
        return results;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public PerformInstructionsResult performIgnoreInstructions(Set<String> variablesToImport) {
        ImportInstructionsConfig instructionsConfig = this.getImportInstructionsConfig();
        ArrayList instructionsExecutionResults = new ArrayList();
        Set ignoreSet = instructionsConfig.getIgnore().stream().filter(ignoreInstruction -> {
            if (variablesToImport.contains(ignoreInstruction)) {
                instructionsExecutionResults.add(ImportInstructionsExecutionResult.builder().id(ignoreInstruction).entityType(ImportEntityType.COMMON_VARIABLE).status(ImportInstructionExecutionStatus.IGNORED).build());
                return true;
            }
            return false;
        }).collect(Collectors.toSet());
        return new PerformInstructionsResult(ignoreSet, instructionsExecutionResults);
    }

    private List<ImportInstructionsExecutionResult> performVariableDeleteInstructions(CommonVariablesImportInstructionsConfig instructionsConfig) {
        ImportInstructionExecutionStatus executionStatus;
        if (Optional.ofNullable(instructionsConfig.getCommonVariables()).map(ImportInstructionsConfig::getDelete).filter(deleteInstructions -> !deleteInstructions.isEmpty()).isEmpty()) {
            return Collections.emptyList();
        }
        Map existingVariables = this.consulService.getAllCommonVariables();
        Set deleteIds = instructionsConfig.getCommonVariables().getDelete();
        List filteredDeleteIds = deleteIds.stream().filter(existingVariables::containsKey).collect(Collectors.toList());
        String errorMessage = null;
        try {
            this.consulService.deleteCommonVariables(filteredDeleteIds);
            this.logCommonVariablesDeleteActions(filteredDeleteIds);
            executionStatus = ImportInstructionExecutionStatus.DELETED;
        }
        catch (Exception e) {
            executionStatus = ImportInstructionExecutionStatus.ERROR_ON_DELETE;
            errorMessage = e.getMessage();
        }
        ArrayList<ImportInstructionsExecutionResult> results = new ArrayList<ImportInstructionsExecutionResult>();
        for (String deleteId : deleteIds) {
            ImportInstructionExecutionStatus executionStatusForVariable;
            ImportInstructionExecutionStatus importInstructionExecutionStatus = executionStatusForVariable = filteredDeleteIds.contains(deleteId) ? executionStatus : ImportInstructionExecutionStatus.NO_ACTION;
            if (executionStatusForVariable == ImportInstructionExecutionStatus.DELETED) {
                log.info("Variable {} deleted as a part of import exclusion list", (Object)deleteId);
            }
            results.add(ImportInstructionsExecutionResult.builder().id(deleteId).entityType(ImportEntityType.COMMON_VARIABLE).status(executionStatusForVariable).errorMessage(errorMessage).build());
        }
        return results;
    }

    private boolean containsOnlyOverriddenByFilter(List<ImportInstructionsFilterRequest> filters) {
        return CollectionUtils.isNotEmpty(filters) && filters.size() == 1 && ImportInstructionsFilterColumn.OVERRIDDEN_BY.equals((Object)filters.get(0).getFeature());
    }

    private void logAction(String instructionId, LogOperation operation) {
        this.actionsLogService.logAction(ActionLog.builder().entityName(instructionId).parentName(ImportEntityType.COMMON_VARIABLE.name()).entityType(EntityType.IMPORT_INSTRUCTION).operation(operation).build());
    }

    private void logCommonVariablesDeleteActions(Collection<String> variableNames) {
        variableNames.forEach(variableName -> this.actionsLogService.logAction(ActionLog.builder().entityName(variableName).entityType(EntityType.COMMON_VARIABLE).operation(LogOperation.DELETE).build()));
    }
}

