/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.configuration;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;
import org.springframework.retry.annotation.EnableRetry;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;

@EnableRetry
@EnableAsync
@AutoConfiguration
@EnableScheduling
@EnableJpaAuditing
@ComponentScan(value={"org.qubership.integration.platform.variables.management"})
public class ApplicationAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ApplicationAutoConfiguration.class);
    private final String cloudServiceName;
    private final String namespace;

    @Autowired
    public ApplicationAutoConfiguration(@Value(value="${spring.application.cloud_service_name}") String cloudServiceName, @Value(value="${cloud.microservice.namespace}") String namespace) {
        this.cloudServiceName = cloudServiceName;
        this.namespace = namespace;
    }

    public String getDeploymentName() {
        return this.cloudServiceName;
    }

    public String getCloudServiceName() {
        return this.cloudServiceName;
    }

    public String getNamespace() {
        return this.namespace;
    }
}

