/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.persistence.configs.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.PreUpdate;
import java.sql.Timestamp;
import java.util.UUID;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.user.User;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@MappedSuperclass
@EntityListeners(value={AuditingEntityListener.class})
public abstract class AbstractEntity {
    @Id
    protected String id;
    protected String name;
    protected String description;
    @Column(updatable=false)
    @CreatedDate
    protected Timestamp createdWhen;
    @LastModifiedDate
    protected Timestamp modifiedWhen;
    @CreatedBy
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="id", column=@Column(name="created_by_id", updatable=false)), @AttributeOverride(name="username", column=@Column(name="created_by_name", updatable=false))})
    protected User createdBy;
    @LastModifiedBy
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="id", column=@Column(name="modified_by_id")), @AttributeOverride(name="username", column=@Column(name="modified_by_name"))})
    protected User modifiedBy;

    protected AbstractEntity(AbstractEntity entity) {
        this.id = UUID.randomUUID().toString();
        this.name = entity.name;
        this.createdWhen = entity.createdWhen;
        this.modifiedWhen = entity.modifiedWhen;
        this.createdBy = entity.createdBy;
        this.modifiedBy = entity.modifiedBy;
        this.description = entity.description;
    }

    public void merge(AbstractEntity entity) {
        this.name = entity.name;
        this.description = entity.description;
    }

    @PreUpdate
    public void preUpdate() {
        if (this.createdWhen == null) {
            this.createdWhen = this.modifiedWhen;
        }
    }

    @JsonIgnore
    public boolean isJustCreated() {
        long createdWhen = this.getCreatedWhen() == null ? -1L : this.getCreatedWhen().getTime();
        long modifiedWhen = this.getModifiedWhen() == null ? -1L : this.getModifiedWhen().getTime();
        return createdWhen == modifiedWhen;
    }

    private static String $default$id() {
        return UUID.randomUUID().toString();
    }

    protected AbstractEntity(AbstractEntityBuilder<?, ?> b) {
        this.id = b.id$set ? b.id$value : AbstractEntity.$default$id();
        this.name = b.name;
        this.description = b.description;
        this.createdWhen = b.createdWhen;
        this.modifiedWhen = b.modifiedWhen;
        this.createdBy = b.createdBy;
        this.modifiedBy = b.modifiedBy;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Timestamp getCreatedWhen() {
        return this.createdWhen;
    }

    public Timestamp getModifiedWhen() {
        return this.modifiedWhen;
    }

    public User getCreatedBy() {
        return this.createdBy;
    }

    public User getModifiedBy() {
        return this.modifiedBy;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCreatedWhen(Timestamp createdWhen) {
        this.createdWhen = createdWhen;
    }

    public void setModifiedWhen(Timestamp modifiedWhen) {
        this.modifiedWhen = modifiedWhen;
    }

    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    public void setModifiedBy(User modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public AbstractEntity() {
        this.id = AbstractEntity.$default$id();
    }

    public static abstract class AbstractEntityBuilder<C extends AbstractEntity, B extends AbstractEntityBuilder<C, B>> {
        private boolean id$set;
        private String id$value;
        private String name;
        private String description;
        private Timestamp createdWhen;
        private Timestamp modifiedWhen;
        private User createdBy;
        private User modifiedBy;

        public B id(String id) {
            this.id$value = id;
            this.id$set = true;
            return this.self();
        }

        public B name(String name) {
            this.name = name;
            return this.self();
        }

        public B description(String description) {
            this.description = description;
            return this.self();
        }

        public B createdWhen(Timestamp createdWhen) {
            this.createdWhen = createdWhen;
            return this.self();
        }

        public B modifiedWhen(Timestamp modifiedWhen) {
            this.modifiedWhen = modifiedWhen;
            return this.self();
        }

        public B createdBy(User createdBy) {
            this.createdBy = createdBy;
            return this.self();
        }

        public B modifiedBy(User modifiedBy) {
            this.modifiedBy = modifiedBy;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "AbstractEntity.AbstractEntityBuilder(id$value=" + this.id$value + ", name=" + this.name + ", description=" + this.description + ", createdWhen=" + String.valueOf(this.createdWhen) + ", modifiedWhen=" + String.valueOf(this.modifiedWhen) + ", createdBy=" + String.valueOf(this.createdBy) + ", modifiedBy=" + String.valueOf(this.modifiedBy) + ")";
        }
    }
}

