/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.actionlog.ActionLog;
import org.qubership.integration.platform.variables.management.rest.v1.dto.actionlog.ActionLogResponse;
import org.qubership.integration.platform.variables.management.rest.v1.dto.actionlog.ActionLogSearchCriteria;
import org.qubership.integration.platform.variables.management.rest.v1.mapper.ActionsLogMapper;
import org.qubership.integration.platform.variables.management.service.ActionsLogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/actions-log"})
@CrossOrigin(origins={"*"})
@Tag(name="actions-log-controller", description="Actions Log Controller")
public class ActionsLogController {
    private static final Logger log = LoggerFactory.getLogger(ActionsLogController.class);
    private final ActionsLogService actionsLogService;
    private final ActionsLogMapper actionsLogMapper;

    @Autowired
    public ActionsLogController(ActionsLogService actionsLogService, ActionsLogMapper actionsLogMapper) {
        this.actionsLogService = actionsLogService;
        this.actionsLogMapper = actionsLogMapper;
    }

    @PostMapping(value={""}, produces={"application/json"})
    @Operation(description="Get action logs")
    public ResponseEntity<ActionLogResponse> findBySearchRequest(@RequestBody @Parameter(description="Search request") ActionLogSearchCriteria request) {
        Pair<Long, List<ActionLog>> actions = this.actionsLogService.findBySearchRequest(request);
        return ResponseEntity.ok((Object)this.actionsLogMapper.asResponse((Long)actions.getLeft(), (List)actions.getRight()));
    }
}

