/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.rest.v1.mapper;

import java.util.ArrayList;
import java.util.List;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.actionlog.ActionLog;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.user.User;
import org.qubership.integration.platform.variables.management.rest.v1.dto.actionlog.ActionLogDTO;
import org.qubership.integration.platform.variables.management.rest.v1.dto.actionlog.ActionLogResponse;
import org.qubership.integration.platform.variables.management.rest.v1.mapper.ActionsLogMapper;
import org.qubership.integration.platform.variables.management.util.MapperUtils;
import org.springframework.stereotype.Component;

@Component
public class ActionsLogMapperImpl
implements ActionsLogMapper {
    @Override
    public ActionLogDTO asDTO(ActionLog action) {
        if (action == null) {
            return null;
        }
        ActionLogDTO.ActionLogDTOBuilder actionLogDTO = ActionLogDTO.builder();
        actionLogDTO.userId(this.actionUserId(action));
        actionLogDTO.username(this.actionUserUsername(action));
        actionLogDTO.id(action.getId());
        actionLogDTO.actionTime(MapperUtils.fromTimestamp(action.getActionTime()));
        actionLogDTO.entityType(action.getEntityType());
        actionLogDTO.entityId(action.getEntityId());
        actionLogDTO.entityName(action.getEntityName());
        actionLogDTO.parentId(action.getParentId());
        actionLogDTO.parentType(action.getParentType());
        actionLogDTO.parentName(action.getParentName());
        actionLogDTO.requestId(action.getRequestId());
        actionLogDTO.operation(action.getOperation());
        return actionLogDTO.build();
    }

    @Override
    public List<ActionLogDTO> asDTO(List<ActionLog> actions) {
        if (actions == null) {
            return null;
        }
        ArrayList<ActionLogDTO> list = new ArrayList<ActionLogDTO>(actions.size());
        for (ActionLog actionLog : actions) {
            list.add(this.asDTO(actionLog));
        }
        return list;
    }

    @Override
    public ActionLogResponse asResponse(Long recordsAfterRange, List<ActionLog> actionLogs) {
        if (recordsAfterRange == null && actionLogs == null) {
            return null;
        }
        ActionLogResponse.ActionLogResponseBuilder actionLogResponse = ActionLogResponse.builder();
        if (recordsAfterRange != null) {
            actionLogResponse.recordsAfterRange(recordsAfterRange);
        }
        actionLogResponse.actionLogs(this.asDTO(actionLogs));
        return actionLogResponse.build();
    }

    private String actionUserId(ActionLog actionLog) {
        if (actionLog == null) {
            return null;
        }
        User user = actionLog.getUser();
        if (user == null) {
            return null;
        }
        String id = user.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    private String actionUserUsername(ActionLog actionLog) {
        if (actionLog == null) {
            return null;
        }
        User user = actionLog.getUser();
        if (user == null) {
            return null;
        }
        String username = user.getUsername();
        if (username == null) {
            return null;
        }
        return username;
    }
}

