/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import jakarta.persistence.EntityExistsException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.integration.platform.variables.management.kubernetes.KubeApiException;
import org.qubership.integration.platform.variables.management.kubernetes.KubeApiNotFoundException;
import org.qubership.integration.platform.variables.management.kubernetes.KubeOperator;
import org.qubership.integration.platform.variables.management.kubernetes.SecretUpdateCallback;
import org.qubership.integration.platform.variables.management.model.SecretEntity;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.actionlog.ActionLog;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.actionlog.EntityType;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.actionlog.LogOperation;
import org.qubership.integration.platform.variables.management.rest.exception.EmptyVariableFieldException;
import org.qubership.integration.platform.variables.management.rest.exception.SecuredVariablesException;
import org.qubership.integration.platform.variables.management.rest.exception.SecuredVariablesNotFoundException;
import org.qubership.integration.platform.variables.management.rest.v2.dto.variables.SecretErrorResponse;
import org.qubership.integration.platform.variables.management.service.ActionsLogService;
import org.qubership.integration.platform.variables.management.service.CommonVariablesService;
import org.qubership.integration.platform.variables.management.service.SecretService;
import org.qubership.integration.platform.variables.management.util.DevModeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SecuredVariableService
extends SecretService {
    private static final Logger log = LoggerFactory.getLogger(SecuredVariableService.class);
    public static final String EMPTY_SECURED_VARIABLE_NAME_ERROR_MESSAGE = "Secured variable's name is empty";
    private final CommonVariablesService commonVariablesService;
    private final Lock lock;
    private final ConcurrentMap<String, SecretEntity> securedVariablesSecrets = new ConcurrentHashMap<String, SecretEntity>();
    private final ObjectMapper objectMapperWithSorting;
    private final DevModeUtil devModeUtil;

    @Autowired
    public SecuredVariableService(@Qualifier(value="yamlMapper") YAMLMapper yamlMapper, @Qualifier(value="primaryObjectMapper") ObjectMapper objectMapper, KubeOperator operator, ActionsLogService actionLogger, @Value(value="${kubernetes.variables-secret.label}") String kubeSecretsLabel, @Value(value="${kubernetes.variables-secret.name}") String kubeSecretV2Name, DevModeUtil devModeUtil, @Lazy CommonVariablesService commonVariablesService, @Qualifier(value="objectMapperWithSorting") ObjectMapper objectMapperWithSorting) {
        super(yamlMapper, objectMapper, operator, actionLogger, kubeSecretsLabel, kubeSecretV2Name);
        this.commonVariablesService = commonVariablesService;
        this.lock = new ReentrantLock(true);
        this.objectMapperWithSorting = objectMapperWithSorting;
        this.devModeUtil = devModeUtil;
    }

    public Map<String, Set<String>> getAllSecretsVariablesNames() {
        this.lock.lock();
        try {
            this.refreshAllVariablesSecrets();
            Map<String, Set<String>> map = this.getVariablesBySecret().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ConcurrentMap)entry.getValue()).keySet()));
            return map;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Set<String> getVariablesForDefaultSecret(boolean failIfSecretNotExist) {
        return this.getVariablesForSecret(this.getKubeSecretV2Name(), failIfSecretNotExist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getVariablesForSecret(String secretName, boolean failIfSecretNotExist) {
        secretName = this.resolveSecretName(secretName);
        this.lock.lock();
        try {
            this.refreshVariablesForSecret(secretName, failIfSecretNotExist);
            SecretEntity secret = (SecretEntity)this.securedVariablesSecrets.get(secretName);
            if (secret == null) {
                if (failIfSecretNotExist) {
                    throw new SecuredVariablesNotFoundException("Secret with name %s not found".formatted(secretName));
                }
                Set<String> set = Collections.emptySet();
                return set;
            }
            Set<String> set = secret.getVariables().keySet();
            return set;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Set<String> addVariablesToDefaultSecret(Map<String, String> newVariables) {
        return this.addVariables(this.getKubeSecretV2Name(), newVariables).get(this.getKubeSecretV2Name());
    }

    public Map<String, Set<String>> addVariables(String secretName, Map<String, String> newVariables) {
        return this.addVariables(secretName, newVariables, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Set<String>> addVariables(String secretName, Map<String, String> newVariables, boolean importMode) {
        HashMap<String, String> oldVariablesCopy;
        if (newVariables.isEmpty()) {
            return Collections.singletonMap(secretName, Collections.emptySet());
        }
        this.lock.lock();
        try {
            secretName = this.resolveSecretName(secretName);
            this.refreshVariablesForSecret(secretName, true);
            SecretEntity secret = (SecretEntity)this.securedVariablesSecrets.get(secretName);
            if (secret == null) {
                throw new SecuredVariablesNotFoundException("Secret with name %s not found".formatted(secretName));
            }
            ConcurrentHashMap<String, String> variables = new ConcurrentHashMap<String, String>(secret.getVariables());
            oldVariablesCopy = new HashMap<String, String>(variables);
            if (this.isDefaultSecret(secretName)) {
                this.validateSecuredVariablesUniqueness(variables, newVariables);
            }
            for (Map.Entry<String, String> securedVariable : newVariables.entrySet()) {
                this.validateSecuredVariable(securedVariable.getKey(), securedVariable.getValue());
            }
            this.updateVariablesCache(secretName, this.operator.addSecretData(secretName, newVariables, variables.isEmpty()));
        }
        finally {
            this.lock.unlock();
        }
        for (String name : newVariables.keySet()) {
            this.logSecuredVariableAction(name, secretName, importMode ? LogOperation.IMPORT : (oldVariablesCopy.containsKey(name) ? LogOperation.UPDATE : LogOperation.CREATE));
        }
        return Collections.singletonMap(secretName, newVariables.keySet());
    }

    public void deleteVariablesFromDefaultSecret(Set<String> variablesNames) {
        this.deleteVariables(this.getKubeSecretV2Name(), variablesNames);
    }

    public void deleteVariables(String secretName, Set<String> variablesNames) {
        this.deleteVariables(secretName, variablesNames, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteVariables(String secretName, Set<String> variablesNames, boolean logOperation) {
        secretName = this.resolveSecretName(secretName);
        if (CollectionUtils.isEmpty(variablesNames)) {
            return;
        }
        this.lock.lock();
        try {
            this.refreshVariablesForSecret(secretName, true);
            SecretEntity secret = (SecretEntity)this.securedVariablesSecrets.get(secretName);
            if (secret == null) {
                throw new SecuredVariablesNotFoundException("Secret with name %s not found".formatted(secretName));
            }
            this.updateVariablesCache(secretName, this.operator.removeSecretData(secretName, variablesNames));
        }
        finally {
            this.lock.unlock();
        }
        if (logOperation) {
            String finalSecretName = secretName;
            variablesNames.forEach(name -> this.logSecuredVariableAction((String)name, finalSecretName, LogOperation.DELETE));
        }
    }

    public List<SecretErrorResponse> deleteVariablesForMultipleSecrets(Map<String, Set<String>> variablesPerSecret) {
        ArrayList<CompletionStage> secretUpdateFutures = new ArrayList<CompletionStage>();
        HashMap<String, RuntimeException> secretUpdateExceptions = new HashMap<String, RuntimeException>();
        this.lock.lock();
        try {
            this.refreshAllVariablesSecrets();
            for (Map.Entry<String, Set<String>> variablePerSecret : variablesPerSecret.entrySet()) {
                String secretName = this.resolveSecretName(variablePerSecret.getKey());
                Set<String> variablesToRemove = variablePerSecret.getValue();
                SecretEntity secret = (SecretEntity)this.securedVariablesSecrets.get(secretName);
                if (secret == null) {
                    secretUpdateExceptions.put(secretName, new SecuredVariablesNotFoundException("Secret with name %s not found".formatted(secretName)));
                    continue;
                }
                try {
                    CompletionStage future = new CompletableFuture().whenComplete((secretData, throwable) -> {
                        if (secretData != null) {
                            this.updateVariablesCache(secretName, (Map<String, String>)secretData);
                            return;
                        }
                        if (throwable != null) {
                            secretUpdateExceptions.put(secretName, (RuntimeException)throwable);
                        }
                    });
                    secretUpdateFutures.add(future);
                    this.operator.removeSecretDataAsync(secretName, variablesToRemove, new SecretUpdateCallback((CompletableFuture<Map<String, String>>)future));
                }
                catch (Exception e) {
                    secretUpdateExceptions.putIfAbsent(secretName, new SecuredVariablesException("Failed to delete variables from secret: " + secretName, e));
                }
            }
            CompletableFuture.allOf(secretUpdateFutures.toArray(new CompletableFuture[0])).get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("Failed to delete variables", (Throwable)e);
            throw new SecuredVariablesException("Failed to delete variables", e);
        }
        finally {
            this.lock.unlock();
        }
        variablesPerSecret.entrySet().stream().filter(entry -> !secretUpdateExceptions.containsKey(entry.getKey())).forEach(entry -> ((Set)entry.getValue()).forEach(variable -> this.logSecuredVariableAction((String)variable, (String)entry.getKey(), LogOperation.DELETE)));
        if (!secretUpdateExceptions.isEmpty()) {
            ArrayList<SecretErrorResponse> errorResponses = new ArrayList<SecretErrorResponse>();
            for (Map.Entry entry2 : secretUpdateExceptions.entrySet()) {
                errorResponses.add(new SecretErrorResponse((String)entry2.getKey(), ((Throwable)entry2.getValue()).getMessage()));
                log.error("Failed to delete variables from secret {}", entry2.getKey(), entry2.getValue());
            }
            if (secretUpdateExceptions.keySet().containsAll(variablesPerSecret.keySet())) {
                throw new SecuredVariablesException("Failed to delete variables from multiple secrets");
            }
            return errorResponses;
        }
        return Collections.emptyList();
    }

    public String updateVariableInDefaultSecret(String name, String value) {
        this.updateVariables(this.getKubeSecretV2Name(), Collections.singletonMap(name, value));
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<String, Set<String>> updateVariables(String secretName, Map<String, String> variablesToUpdate) {
        secretName = this.resolveSecretName(secretName);
        this.lock.lock();
        try {
            this.refreshVariablesForSecret(secretName, true);
            ConcurrentHashMap<String, String> variables = new ConcurrentHashMap<String, String>(((SecretEntity)this.securedVariablesSecrets.get(secretName)).getVariables());
            for (Map.Entry<String, String> variable : variablesToUpdate.entrySet()) {
                String name2 = variable.getKey();
                String value = variable.getValue();
                this.validateSecuredVariable(name2, value);
                if (!variables.containsKey(name2)) {
                    throw new SecuredVariablesNotFoundException("Cannot find variable " + name2);
                }
                variables.put(name2, Objects.isNull(value) ? "" : value);
            }
            this.updateVariablesCache(secretName, this.operator.updateSecretData(secretName, variables));
        }
        finally {
            this.lock.unlock();
        }
        String finalSecretName = secretName;
        variablesToUpdate.keySet().forEach(name -> this.logSecuredVariableAction((String)name, finalSecretName, LogOperation.UPDATE));
        return Pair.of((Object)secretName, variablesToUpdate.keySet());
    }

    public Set<String> importVariablesRequest(MultipartFile file) {
        Map importedVariables;
        try {
            importedVariables = (Map)this.yamlMapper.readValue(new String(file.getBytes()), (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (IOException e) {
            log.error("Unable to convert file to variables {}", (Object)e.getMessage());
            throw new RuntimeException("Unable to convert file to variables");
        }
        this.addVariables(this.getKubeSecretV2Name(), importedVariables, true);
        importedVariables.keySet().forEach(name -> this.logSecuredVariableAction((String)name, this.getKubeSecretV2Name(), LogOperation.IMPORT));
        return importedVariables.keySet();
    }

    protected Map<String, SecretEntity> getSecuredVariablesSecrets() {
        return this.securedVariablesSecrets;
    }

    private void validateSecuredVariable(String name, String value) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new EmptyVariableFieldException(EMPTY_SECURED_VARIABLE_NAME_ERROR_MESSAGE);
        }
    }

    private void validateSecuredVariablesUniqueness(Map<String, String> currentVariables, Map<String, String> newVariables) {
        Map<String, String> commonVariables = this.commonVariablesService.getVariables();
        for (Map.Entry<String, String> commonVariable : commonVariables.entrySet()) {
            String name = commonVariable.getKey();
            if (!currentVariables.containsKey(name) && !newVariables.containsKey(name)) continue;
            throw new EntityExistsException("Common variable with name " + name + " already exists");
        }
    }

    private ConcurrentMap<String, ConcurrentMap<String, String>> getVariablesBySecret() {
        ConcurrentHashMap<String, ConcurrentMap<String, String>> variables = new ConcurrentHashMap<String, ConcurrentMap<String, String>>();
        for (Map.Entry entry : this.securedVariablesSecrets.entrySet()) {
            variables.put((String)entry.getKey(), ((SecretEntity)entry.getValue()).getVariables());
        }
        return variables;
    }

    private void refreshAllVariablesSecrets() {
        ConcurrentMap<String, ConcurrentMap<String, String>> foundSecrets;
        try {
            foundSecrets = this.operator.getAllSecretsWithLabel(this.getKubeSecretsLabel());
        }
        catch (KubeApiException e) {
            log.error("Can't get kube secrets {}", (Object)e.getMessage());
            if (!this.devModeUtil.isDevMode()) {
                throw e;
            }
            foundSecrets = new ConcurrentHashMap<String, ConcurrentMap<String, String>>();
        }
        this.securedVariablesSecrets.clear();
        for (Map.Entry entry : foundSecrets.entrySet()) {
            String secretName = (String)entry.getKey();
            ConcurrentMap secretData = (ConcurrentMap)entry.getValue();
            this.updateVariablesCache(secretName, secretData);
        }
    }

    private void refreshVariablesForSecret(String secretName, boolean failIfSecretNotExist) {
        block4: {
            try {
                ConcurrentMap<String, String> secretData = this.operator.getSecretByName(secretName, failIfSecretNotExist);
                this.updateVariablesCache(secretName, secretData);
            }
            catch (KubeApiNotFoundException e) {
                log.error("Cannot get secured variables from secret", (Throwable)e);
                this.securedVariablesSecrets.remove(secretName);
                if (!this.devModeUtil.isDevMode()) {
                    throw new SecuredVariablesNotFoundException("Secret with name %s not found".formatted(secretName), e);
                }
            }
            catch (KubeApiException e) {
                log.error("Can't get kube secret: {}", (Object)e.getMessage());
                if (this.devModeUtil.isDevMode()) break block4;
                throw e;
            }
        }
    }

    private void updateVariablesCache(String secretName, Map<String, String> variables) {
        this.securedVariablesSecrets.put(secretName, SecretEntity.builder().secretName(secretName).variables(new ConcurrentHashMap<String, String>(variables)).build());
    }

    private String resolveSecretName(@Nullable String secretName) {
        return StringUtils.isBlank((CharSequence)secretName) || "default".equalsIgnoreCase(secretName) ? this.getKubeSecretV2Name() : secretName;
    }

    private void logSecuredVariableAction(String name, String secretName, LogOperation operation) {
        this.actionLogger.logAction(ActionLog.builder().entityType(EntityType.SECURED_VARIABLE).entityName(name).parentType(EntityType.SECRET).parentName(secretName).operation(operation).build());
    }
}

