/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.service.exportimport.instructions.mapper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.qubership.integration.platform.variables.management.model.exportimport.instructions.CommonVariablesImportInstructionsConfig;
import org.qubership.integration.platform.variables.management.model.exportimport.instructions.ImportInstructionAction;
import org.qubership.integration.platform.variables.management.model.exportimport.instructions.ImportInstructionsConfig;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.exportimport.instructions.ImportInstruction;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.exportimport.instructions.ImportInstructionLabel;
import org.qubership.integration.platform.variables.management.rest.v1.dto.variables.instructions.ImportInstructionDTO;
import org.qubership.integration.platform.variables.management.rest.v1.dto.variables.instructions.ImportInstructionsDTO;
import org.springframework.stereotype.Component;

@Component
public class ImportInstructionsMapper {
    public ImportInstructionsConfig asConfig(List<ImportInstruction> importInstructions) {
        HashSet<String> delete = new HashSet<String>();
        HashSet<String> ignore = new HashSet<String>();
        for (ImportInstruction importInstruction : importInstructions) {
            if (importInstruction.getAction() == ImportInstructionAction.DELETE) {
                delete.add(importInstruction.getId());
                continue;
            }
            if (importInstruction.getAction() != ImportInstructionAction.IGNORE) continue;
            ignore.add(importInstruction.getId());
        }
        return ((ImportInstructionsConfig.ImportInstructionsConfigBuilder)((ImportInstructionsConfig.ImportInstructionsConfigBuilder)ImportInstructionsConfig.builder().delete(delete)).ignore(ignore)).build();
    }

    public List<ImportInstruction> asEntities(CommonVariablesImportInstructionsConfig commonVariablesImportInstructionsConfig) {
        ImportInstructionsConfig importInstructionsConfig = commonVariablesImportInstructionsConfig.getCommonVariables();
        if (importInstructionsConfig == null) {
            return Collections.emptyList();
        }
        ArrayList<ImportInstruction> importInstructions = new ArrayList<ImportInstruction>();
        for (String id : importInstructionsConfig.getIgnore()) {
            Object importInstruction = ((ImportInstruction.ImportInstructionBuilder)((ImportInstruction.ImportInstructionBuilder)ImportInstruction.builder().id(id)).action(ImportInstructionAction.IGNORE)).build();
            if (CollectionUtils.isNotEmpty(commonVariablesImportInstructionsConfig.getLabels())) {
                ((ImportInstruction)importInstruction).setLabels(commonVariablesImportInstructionsConfig.getLabels().stream().map(labelName -> ((ImportInstructionLabel.ImportInstructionLabelBuilder)((ImportInstructionLabel.ImportInstructionLabelBuilder)ImportInstructionLabel.builder().name((String)labelName)).importInstruction((ImportInstruction)importInstruction)).build()).collect(Collectors.toList()));
            }
            importInstructions.add((ImportInstruction)importInstruction);
        }
        return importInstructions;
    }

    public ImportInstructionsDTO asDto(List<ImportInstruction> importInstructions) {
        HashSet<ImportInstructionDTO> variablesToDelete = new HashSet<ImportInstructionDTO>();
        HashSet<ImportInstructionDTO> variablesToIgnore = new HashSet<ImportInstructionDTO>();
        for (ImportInstruction importInstruction : importInstructions) {
            if (ImportInstructionAction.DELETE.equals((Object)importInstruction.getAction())) {
                variablesToDelete.add(this.entityToDto(importInstruction));
                continue;
            }
            if (!ImportInstructionAction.IGNORE.equals((Object)importInstruction.getAction())) continue;
            variablesToIgnore.add(this.entityToDto(importInstruction));
        }
        return ((ImportInstructionsDTO.ImportInstructionsDTOBuilder)((ImportInstructionsDTO.ImportInstructionsDTOBuilder)ImportInstructionsDTO.builder().delete(variablesToDelete)).ignore(variablesToIgnore)).build();
    }

    public ImportInstructionDTO entityToDto(ImportInstruction importInstruction) {
        Long modifiedWhen = importInstruction.getModifiedWhen() != null ? Long.valueOf(importInstruction.getModifiedWhen().getTime()) : null;
        Set<String> labels = CollectionUtils.isEmpty(importInstruction.getLabels()) ? Collections.emptySet() : importInstruction.getLabels().stream().map(ImportInstructionLabel::getName).collect(Collectors.toSet());
        return ((ImportInstructionDTO.ImportInstructionDTOBuilder)((ImportInstructionDTO.ImportInstructionDTOBuilder)((ImportInstructionDTO.ImportInstructionDTOBuilder)((ImportInstructionDTO.ImportInstructionDTOBuilder)ImportInstructionDTO.builder().id(importInstruction.getId())).labels(labels)).modifiedWhen(modifiedWhen)).preview(modifiedWhen == null)).build();
    }
}

