/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.util;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;

public class DistinctByKey<T>
implements Predicate<T> {
    private final Function<T, Object> keyExtractor;
    private final Set<Object> seenObjects;

    private DistinctByKey(Function<T, Object> keyExtractor) {
        this.keyExtractor = keyExtractor;
        this.seenObjects = ConcurrentHashMap.newKeySet();
    }

    public static <T> DistinctByKey<T> newInstance(Function<T, Object> keyExtractor) {
        return new DistinctByKey<T>(keyExtractor);
    }

    @Override
    public boolean test(T key) {
        return this.seenObjects.add(this.keyExtractor.apply(key));
    }
}

