/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.rest.v2.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.integration.platform.variables.management.rest.v2.dto.variables.SecretResponse;
import org.qubership.integration.platform.variables.management.rest.v2.dto.variables.SecuredVariablesRequest;
import org.qubership.integration.platform.variables.management.rest.v2.mapper.SecretResponseMapper;
import org.qubership.integration.platform.variables.management.service.SecuredVariableService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v2/secured-variables"})
@CrossOrigin(origins={"*"})
@Validated
@Tag(name="secured-variable-controller-v-2", description="Secured Variable Controller V2")
public class SecuredVariableControllerV2 {
    private static final Logger log = LoggerFactory.getLogger(SecuredVariableControllerV2.class);
    private final SecuredVariableService securedVariableService;
    private final SecretResponseMapper secretResponseMapper;

    @Autowired
    public SecuredVariableControllerV2(SecuredVariableService securedVariableService, SecretResponseMapper secretResponseMapper) {
        this.securedVariableService = securedVariableService;
        this.secretResponseMapper = secretResponseMapper;
    }

    @Operation(description="Get all secured variables names from all secrets")
    @GetMapping
    public ResponseEntity<List<SecretResponse>> getVariables() {
        if (log.isDebugEnabled()) {
            log.debug("Request to get secured variables from all secrets");
        }
        Map secrets = this.securedVariableService.getAllSecretsVariablesNames();
        return ResponseEntity.ok((Object)this.secretResponseMapper.asResponse(secrets));
    }

    @Operation(description="Get all secured variables names from specified secret")
    @GetMapping(value={"/{secretName}"})
    public ResponseEntity<Set<String>> getVariablesForSecret(@PathVariable @Parameter(description="Name of secret") String secretName) {
        if (log.isDebugEnabled()) {
            log.debug("Request to get secured variables from secret {}", (Object)secretName);
        }
        return ResponseEntity.ok((Object)this.securedVariableService.getVariablesForSecret(secretName, true));
    }

    @Operation(description="Add new secured variables")
    @PostMapping
    public ResponseEntity<List<SecretResponse>> addVariables(@Valid @RequestBody SecuredVariablesRequest request) {
        log.info("Request to add secured variables to secret {}", (Object)request.getSecretName());
        Map secrets = this.securedVariableService.addVariables(request.getSecretName(), request.getVariables());
        return ResponseEntity.ok((Object)this.secretResponseMapper.asResponse(secrets));
    }

    @Operation(description="Update secured variables")
    @PatchMapping
    public ResponseEntity<SecretResponse> updateVariable(@RequestBody SecuredVariablesRequest updateRequest) {
        log.info("Request to update secured variables {}", updateRequest.getVariables().keySet());
        Pair updatedVariables = this.securedVariableService.updateVariables(updateRequest.getSecretName(), updateRequest.getVariables());
        return ResponseEntity.ok((Object)this.secretResponseMapper.asResponse((Map.Entry)updatedVariables));
    }

    @Operation(description="Delete secured variables from specified secret")
    @DeleteMapping(value={"/{secretName}"})
    public ResponseEntity<Void> deleteVariablesFromSecret(@PathVariable @Parameter(description="Name of secret") String secretName, @RequestParam @Parameter(description="Set of variables names for removal") Set<String> variablesNames) {
        log.info("Request to delete secured variables from secret {}", (Object)secretName);
        this.securedVariableService.deleteVariables(secretName, variablesNames);
        return ResponseEntity.noContent().build();
    }

    @Operation(description="Delete secured variables from multiple specified secrets")
    @DeleteMapping
    public ResponseEntity<?> deleteVariables(@RequestBody @Parameter(description="Request map of <Secret name, Set<Variable name>>") Map<String, Set<String>> secretsVariables) {
        log.info("Request to delete secured variables");
        List errorResponses = this.securedVariableService.deleteVariablesForMultipleSecrets(secretsVariables);
        return errorResponses.isEmpty() ? ResponseEntity.noContent().build() : ResponseEntity.status((HttpStatusCode)HttpStatus.MULTI_STATUS).body((Object)errorResponses);
    }
}

