/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import io.kubernetes.client.openapi.models.V1Secret;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.integration.platform.variables.management.kubernetes.KubeOperator;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.actionlog.ActionLog;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.actionlog.EntityType;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.actionlog.LogOperation;
import org.qubership.integration.platform.variables.management.rest.exception.SecuredVariablesException;
import org.qubership.integration.platform.variables.management.rest.exception.SecuredVariablesNotFoundException;
import org.qubership.integration.platform.variables.management.service.ActionsLogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;

@Service
public class SecretService {
    private static final Logger log = LoggerFactory.getLogger(SecretService.class);
    private final String kubeSecretV2Name;
    private final Pair<String, String> kubeSecretsLabel;
    public static final String SECRET_NOT_FOUND_ERROR_MESSAGE_FORMAT = "Secret with name %s not found";
    protected final YAMLMapper yamlMapper;
    protected final ObjectMapper jsonMapper;
    protected final KubeOperator operator;
    protected final ActionsLogService actionLogger;

    @Autowired
    public SecretService(@Qualifier(value="yamlMapper") YAMLMapper yamlMapper, @Qualifier(value="primaryObjectMapper") ObjectMapper objectMapper, KubeOperator operator, ActionsLogService actionLogger, @Value(value="${kubernetes.variables-secret.label}") String kubeSecretsLabel, @Value(value="${kubernetes.variables-secret.name}") String kubeSecretV2Name) {
        this.yamlMapper = yamlMapper;
        this.jsonMapper = objectMapper;
        this.operator = operator;
        this.actionLogger = actionLogger;
        this.kubeSecretV2Name = kubeSecretV2Name;
        this.kubeSecretsLabel = Pair.of((Object)kubeSecretsLabel, (Object)"secured");
    }

    public void createSecuredVariablesSecret(String name) {
        this.createSecuredVariablesSecret(name, null);
    }

    public void createSecuredVariablesSecret(String name, @Nullable Map<String, String> securedVariables) {
        if (this.operator.getSecretObjectByName(name) != null) {
            return;
        }
        this.operator.createSecret(name, this.kubeSecretsLabel, securedVariables);
        this.logCreateAction(EntityType.SECRET, name);
        Set<Object> variablesKeys = securedVariables == null ? Collections.emptySet() : securedVariables.keySet();
        for (String string : variablesKeys) {
            this.logCreateAction(EntityType.SECURED_VARIABLE, string);
        }
    }

    public String getSecretTemplate(String secretName) {
        try {
            V1Secret foundSecret = this.operator.getSecretObjectByName(secretName);
            if (foundSecret == null) {
                throw new SecuredVariablesNotFoundException(SECRET_NOT_FOUND_ERROR_MESSAGE_FORMAT.formatted(secretName));
            }
            return this.yamlMapper.writeValueAsString((Object)foundSecret);
        }
        catch (JsonProcessingException e) {
            throw new SecuredVariablesException("Failed to get secret helm chart", (Throwable)e);
        }
    }

    public boolean isDefaultSecret(String secretName) {
        return this.kubeSecretV2Name.equals(secretName);
    }

    private void logCreateAction(EntityType entityType, String name) {
        this.actionLogger.logAction(ActionLog.builder().entityType(entityType).entityName(name).operation(LogOperation.CREATE).build());
    }

    public String getKubeSecretV2Name() {
        return this.kubeSecretV2Name;
    }

    public Pair<String, String> getKubeSecretsLabel() {
        return this.kubeSecretsLabel;
    }
}

