/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import org.qubership.integration.platform.variables.management.model.exportimport.instructions.ImportInstructionsConfig;
import org.qubership.integration.platform.variables.management.model.exportimport.instructions.ImportInstructionsExecutionResult;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.exportimport.instructions.ImportInstruction;
import org.qubership.integration.platform.variables.management.rest.v1.dto.instructions.ImportInstructionsFilterRequest;
import org.qubership.integration.platform.variables.management.rest.v1.dto.instructions.ImportInstructionsSearchRequest;
import org.qubership.integration.platform.variables.management.rest.v1.dto.variables.instructions.ImportInstructionDTO;
import org.qubership.integration.platform.variables.management.rest.v1.dto.variables.instructions.ImportInstructionRequest;
import org.qubership.integration.platform.variables.management.rest.v1.dto.variables.instructions.ImportInstructionsDTO;
import org.qubership.integration.platform.variables.management.rest.v1.mapper.ImportInstructionRequestMapper;
import org.qubership.integration.platform.variables.management.service.exportimport.instructions.ImportInstructionsService;
import org.qubership.integration.platform.variables.management.service.exportimport.instructions.mapper.ImportInstructionsMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/v1/common-variables/import-instructions"})
@CrossOrigin(origins={"*"})
@Tag(name="import-instructions-controller", description="Import Instructions Controller")
public class ImportInstructionsController {
    private static final Logger log = LoggerFactory.getLogger(ImportInstructionsController.class);
    private final ImportInstructionsService importInstructionsService;
    private final ImportInstructionsMapper importInstructionsMapper;
    private final ImportInstructionRequestMapper importInstructionRequestMapper;

    @Autowired
    public ImportInstructionsController(ImportInstructionsService importInstructionsService, ImportInstructionsMapper importInstructionsMapper, ImportInstructionRequestMapper importInstructionRequestMapper) {
        this.importInstructionsService = importInstructionsService;
        this.importInstructionsMapper = importInstructionsMapper;
        this.importInstructionRequestMapper = importInstructionRequestMapper;
    }

    @GetMapping(produces={"application/json"})
    @Operation(description="Get all import instructions for common variables")
    public ResponseEntity<ImportInstructionsDTO> getImportInstructions() {
        List<ImportInstruction> importInstructions = this.importInstructionsService.getImportInstructions();
        return ResponseEntity.ok((Object)this.importInstructionsMapper.asDto(importInstructions));
    }

    @GetMapping(path={"/config"}, produces={"application/json"})
    @Operation(description="Get all import instructions for common variables in the configuration format")
    public ResponseEntity<ImportInstructionsConfig> getImportInstructionsConfig() {
        return ResponseEntity.ok((Object)this.importInstructionsService.getImportInstructionsConfig());
    }

    @PostMapping(path={"/search"}, produces={"application/json"})
    @Operation(description="Search for import instructions")
    public ResponseEntity<ImportInstructionsDTO> searchImportInstructions(@RequestBody @Parameter(description="Import instructions search request object") ImportInstructionsSearchRequest searchRequest) {
        List<ImportInstruction> importInstructions = this.importInstructionsService.searchImportInstructions(searchRequest.getSearchCondition());
        return ResponseEntity.ok((Object)this.importInstructionsMapper.asDto(importInstructions));
    }

    @PostMapping(path={"/filter"}, produces={"application/json"})
    @Operation(description="Filter import instructions")
    public ResponseEntity<ImportInstructionsDTO> filterImportInstructions(@RequestBody @Parameter(description="Import instructions filter request object") List<ImportInstructionsFilterRequest> filterRequests) {
        List<ImportInstruction> importInstructions = this.importInstructionsService.getImportInstructions(filterRequests);
        return ResponseEntity.ok((Object)this.importInstructionsMapper.asDto(importInstructions));
    }

    @PostMapping(path={"/upload"}, consumes={"multipart/form-data"})
    @Operation(description="Upload import instructions configuration from file")
    public ResponseEntity<List<ImportInstructionsExecutionResult>> uploadImportInstructionsConfig(@RequestParam(value="file") @Parameter(description="Yaml file") MultipartFile file, @RequestHeader(value="labels", required=false) @Parameter(description="List of labels that should be added on uploaded instructions") List<String> labels) {
        return ResponseEntity.ok(this.importInstructionsService.uploadImportInstructions(file, labels));
    }

    @PostMapping(consumes={"application/json"})
    @Operation(description="Create new import instruction")
    public ResponseEntity<ImportInstructionDTO> addImportInstruction(@RequestBody @Valid @Parameter(description="Create import instructions request object") ImportInstructionRequest importInstructionRequest) {
        ImportInstruction importInstruction = this.importInstructionRequestMapper.toEntity(importInstructionRequest);
        importInstruction = this.importInstructionsService.addImportInstruction(importInstruction);
        return ResponseEntity.ok((Object)this.importInstructionsMapper.entityToDto(importInstruction));
    }

    @PatchMapping(consumes={"application/json"})
    @Operation(description="Update existing import instruction")
    public ResponseEntity<ImportInstructionDTO> updateImportInstruction(@RequestBody @Valid @Parameter(description="Update import instruction request object") ImportInstructionRequest importInstructionRequest) {
        ImportInstruction importInstruction = this.importInstructionRequestMapper.toEntity(importInstructionRequest);
        importInstruction = this.importInstructionsService.updateImportInstruction(importInstruction);
        return ResponseEntity.ok((Object)this.importInstructionsMapper.entityToDto(importInstruction));
    }

    @DeleteMapping(consumes={"application/json"})
    @Operation(description="Delete import instructions")
    public ResponseEntity<Void> deleteImportInstructions(@RequestBody @Parameter(description="List of import instructions ids to delete") List<String> importInstructionIds) {
        this.importInstructionsService.deleteImportInstructionsByIds(importInstructionIds);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).build();
    }
}

