/*
 * Copyright 2024-2025 NetCracker Technology Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.qubership.integration.platform.variables.management.validation.constraint;

import jakarta.validation.Constraint;
import jakarta.validation.Payload;
import org.qubership.integration.platform.variables.management.validation.EntityValidator;

import java.lang.annotation.*;

/**
 * The annotated element must not start or end with a whitespace. Accepts only string.
 */
@Constraint(validatedBy = EntityValidator.NotStartOrEndWithSpaceValidator.class)
@Retention(RetentionPolicy.RUNTIME)
@Target({ ElementType.FIELD, ElementType.TYPE_USE })
public @interface NotStartOrEndWithSpace {

    String message() default "String must not start or end with a space";

    /**
     * Specifies whether the value can be empty.
     */
    boolean optional() default false;

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};
}
