/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.configuration.datasource.properties;

import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.flywaydb.core.api.configuration.ClassicConfiguration;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="db")
public class FlywayConfigProperties {
    private Map<String, Properties> flyway;

    public ClassicConfiguration getConfig(String name) {
        return Optional.ofNullable((Properties)this.flyway.get(name)).map(props -> {
            ClassicConfiguration configuration = new ClassicConfiguration();
            configuration.configure(this.getConfigurationMap(props));
            return configuration;
        }).orElseGet(ClassicConfiguration::new);
    }

    private Map<String, String> getConfigurationMap(Properties properties) {
        return this.addPrefix("flyway.", ConfigUtils.propertiesToMap((Properties)properties));
    }

    private Map<String, String> addPrefix(String prefix, Map<String, String> map) {
        return map.entrySet().stream().collect(Collectors.toMap(e -> prefix + (String)e.getKey(), Map.Entry::getValue));
    }

    public Map<String, Properties> getFlyway() {
        return this.flyway;
    }

    public void setFlyway(Map<String, Properties> flyway) {
        this.flyway = flyway;
    }

    public FlywayConfigProperties(Map<String, Properties> flyway) {
        this.flyway = flyway;
    }
}

