/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.kubernetes;

import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.models.V1Secret;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import okhttp3.Call;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.integration.platform.variables.management.kubernetes.KubeApiException;
import org.qubership.integration.platform.variables.management.kubernetes.KubeApiNotFoundException;
import org.qubership.integration.platform.variables.management.kubernetes.KubeOperator;
import org.qubership.integration.platform.variables.management.kubernetes.SecretAlreadyExists;
import org.qubership.integration.platform.variables.management.kubernetes.SecretUpdateCallback;

public class LocalDevKubeOperator
implements KubeOperator {
    private final ConcurrentMap<String, ConcurrentMap<String, String>> secrets = new ConcurrentHashMap();

    public Map<String, ? extends Map<String, String>> getAllSecretsWithLabel(Pair<String, String> label) {
        return this.secrets;
    }

    public V1Secret getSecretObjectByName(String name) {
        ConcurrentMap data = (ConcurrentMap)this.secrets.get(name);
        if (Objects.isNull(data)) {
            return null;
        }
        V1Secret secret = new V1Secret();
        secret.setData(data.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((String)e.getValue()).getBytes())));
        return secret;
    }

    public Map<String, String> getSecretByName(String name, boolean failIfNotExist) throws KubeApiException {
        Map data = (Map)this.secrets.get(name);
        if (Objects.isNull(data)) {
            if (failIfNotExist) {
                throw new KubeApiNotFoundException("Kube secret not found: " + name);
            }
            return Collections.emptyMap();
        }
        return data;
    }

    public void createSecret(String name, Pair<String, String> label, Map<String, String> data) {
        if (Objects.nonNull(this.secrets.putIfAbsent(name, Objects.isNull(data) ? new ConcurrentHashMap() : new ConcurrentHashMap<String, String>(data)))) {
            throw new SecretAlreadyExists("Secret with name " + name + " already exists");
        }
    }

    public Map<String, String> addSecretData(String secretName, Map<String, String> data, boolean init) {
        return this.modifySecretData(secretName, v -> {
            v.putAll(data);
            return v;
        });
    }

    public Map<String, String> removeSecretData(String secretName, Set<String> keys) {
        return this.modifySecretData(secretName, v -> {
            keys.forEach(v::remove);
            return v;
        });
    }

    public Call removeSecretDataAsync(String secretName, Set<String> keys, SecretUpdateCallback callback) {
        try {
            this.removeSecretData(secretName, keys);
            callback.onSuccess(this.getSecretObjectByName(secretName), 200, Collections.emptyMap());
        }
        catch (Exception e) {
            callback.onFailure(new ApiException((Throwable)e), 500, Collections.emptyMap());
        }
        return null;
    }

    public Map<String, String> updateSecretData(String secretName, Map<String, String> data) {
        return this.modifySecretData(secretName, v -> {
            v.putAll(data);
            return v;
        });
    }

    private Map<String, String> modifySecretData(String secretName, Function<ConcurrentMap<String, String>, ConcurrentMap<String, String>> modifier) {
        ConcurrentMap result = this.secrets.computeIfPresent(secretName, (k, v) -> (ConcurrentMap)modifier.apply((ConcurrentMap<String, String>)v));
        if (Objects.isNull(result)) {
            throw new KubeApiNotFoundException("Kube secret not found: " + secretName);
        }
        return result;
    }
}

