/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.service.secrets;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import io.kubernetes.client.openapi.models.V1Secret;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import okhttp3.Call;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.integration.platform.variables.management.kubernetes.KubeApiException;
import org.qubership.integration.platform.variables.management.kubernetes.KubeApiNotFoundException;
import org.qubership.integration.platform.variables.management.kubernetes.KubeOperator;
import org.qubership.integration.platform.variables.management.kubernetes.SecretUpdateCallback;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.actionlog.ActionLog;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.actionlog.EntityType;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.actionlog.LogOperation;
import org.qubership.integration.platform.variables.management.rest.exception.SecretNotFoundException;
import org.qubership.integration.platform.variables.management.rest.exception.SecuredVariablesException;
import org.qubership.integration.platform.variables.management.service.ActionsLogService;
import org.qubership.integration.platform.variables.management.service.secrets.SecretService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class K8sSecretService
implements SecretService {
    private static final Logger log = LoggerFactory.getLogger(K8sSecretService.class);
    private final KubeOperator kubeOperator;
    private final ActionsLogService actionLogger;
    private final YAMLMapper yamlMapper;
    private final Pair<String, String> kubeSecretsLabel;
    private final String kubeSecretV2Name;

    @Autowired
    public K8sSecretService(KubeOperator kubeOperator, ActionsLogService actionLogger, @Qualifier(value="yamlMapper") YAMLMapper yamlMapper, @Value(value="${kubernetes.variables-secret.label}") String label, @Value(value="${kubernetes.variables-secret.name}") String kubeSecretV2Name) {
        this.kubeOperator = kubeOperator;
        this.actionLogger = actionLogger;
        this.yamlMapper = yamlMapper;
        this.kubeSecretsLabel = Pair.of((Object)label, (Object)"secured");
        this.kubeSecretV2Name = kubeSecretV2Name;
    }

    public Map<String, ? extends Map<String, String>> getAllSecretsData() {
        try {
            return this.kubeOperator.getAllSecretsWithLabel(this.kubeSecretsLabel);
        }
        catch (KubeApiException exception) {
            log.error("Can't get kube secrets {}", (Object)exception.getMessage());
            throw exception;
        }
    }

    public Map<String, String> getSecretData(String secretName, boolean failIfNotExist) {
        try {
            return this.kubeOperator.getSecretByName(secretName, failIfNotExist);
        }
        catch (KubeApiNotFoundException exception) {
            log.error("Cannot get data from secret", (Throwable)exception);
            throw SecretNotFoundException.forSecretAndCause((String)secretName, (Throwable)exception);
        }
        catch (KubeApiException exception) {
            log.error("Can't get kube secret: {}", (Object)exception.getMessage());
            throw exception;
        }
    }

    public boolean createSecret(String secretName) {
        try {
            if (Objects.nonNull(this.kubeOperator.getSecretObjectByName(secretName))) {
                return false;
            }
            this.kubeOperator.createSecret(secretName, this.kubeSecretsLabel, null);
            this.logAction(secretName, LogOperation.CREATE);
            return true;
        }
        catch (KubeApiException exception) {
            log.error("Failed to create secret", (Throwable)exception);
            throw exception;
        }
    }

    public Map<String, String> addEntries(String secretName, Map<String, String> data, boolean init) {
        try {
            return this.kubeOperator.addSecretData(secretName, data, init);
        }
        catch (KubeApiException exception) {
            log.error("Failed to add data to secret", (Throwable)exception);
            throw exception;
        }
    }

    public Map<String, String> updateEntries(String secretName, Map<String, String> data) {
        try {
            return this.kubeOperator.updateSecretData(secretName, data);
        }
        catch (KubeApiException exception) {
            log.error("Failed to update data to secret", (Throwable)exception);
            throw exception;
        }
    }

    public Map<String, String> removeEntries(String secretName, Set<String> keys) {
        try {
            return this.kubeOperator.removeSecretData(secretName, keys);
        }
        catch (KubeApiException exception) {
            log.error("Failed to remove data from secret", (Throwable)exception);
            throw exception;
        }
    }

    public Call removeEntriesAsync(String secretName, Set<String> keys, SecretUpdateCallback callback) {
        return this.kubeOperator.removeSecretDataAsync(secretName, keys, callback);
    }

    public String getSecretTemplate(String secretName) {
        try {
            V1Secret secret = this.kubeOperator.getSecretObjectByName(secretName);
            if (Objects.isNull(secret)) {
                throw SecretNotFoundException.forSecret((String)secretName);
            }
            return this.yamlMapper.writeValueAsString((Object)secret);
        }
        catch (JsonProcessingException e) {
            throw new SecuredVariablesException("Failed to get secret helm chart", (Throwable)e);
        }
    }

    public String getDefaultSecretName() {
        return this.kubeSecretV2Name;
    }

    private void logAction(String secretName, LogOperation operation) {
        ActionLog action = ActionLog.builder().entityType(EntityType.SECRET).entityName(secretName).operation(operation).build();
        this.actionLogger.logAction(action);
    }
}

