/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.validation;

import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validator;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EntityValidator {
    public static final String ENTITY_NAME_REGEXP = "^[-._a-zA-Z0-9]+$";
    public static final Predicate<String> VARIABLE_NAME_PATTERN_PREDICATE = Pattern.compile("^[-._a-zA-Z0-9]+$").asMatchPredicate();
    private final Validator validator;

    @Autowired
    public EntityValidator(Validator validator) {
        this.validator = validator;
    }

    public void validate(Object entity) {
        Set constraintViolations = this.validator.validate(entity, new Class[0]);
        if (!constraintViolations.isEmpty()) {
            throw new ConstraintViolationException(constraintViolations);
        }
    }
}

