/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.kubernetes;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.openapi.ApiCallback;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.AppsV1Api;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.apis.CustomObjectsApi;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1Secret;
import io.kubernetes.client.openapi.models.V1SecretList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import okhttp3.Call;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.integration.platform.variables.management.kubernetes.KubeApiException;
import org.qubership.integration.platform.variables.management.kubernetes.KubeApiNotFoundException;
import org.qubership.integration.platform.variables.management.kubernetes.KubeOperator;
import org.qubership.integration.platform.variables.management.kubernetes.SecretAlreadyExists;
import org.qubership.integration.platform.variables.management.kubernetes.SecretUpdateCallback;
import org.qubership.integration.platform.variables.management.model.json.JsonPatch;
import org.qubership.integration.platform.variables.management.model.json.PatchOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public class DefaultKubeOperator
implements KubeOperator {
    private static final Logger log = LoggerFactory.getLogger(DefaultKubeOperator.class);
    public static final String SECRET_LABELS_PATH = "/metadata/labels";
    public static final String SECRET_DATA_PATH = "/data";
    private static final String METADATA_NAME_FIELD = "metadata.name";
    private static final String DEFAULT_ERR_MESSAGE = "Invalid k8s cluster parameters or API error. ";
    private final ObjectMapper objectMapper;
    private final CoreV1Api coreApi = new CoreV1Api();
    private final AppsV1Api appsApi;
    private final CustomObjectsApi customObjectsApi;
    private final String namespace;

    public DefaultKubeOperator() {
        this.appsApi = new AppsV1Api();
        this.customObjectsApi = new CustomObjectsApi();
        this.namespace = null;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }

    public DefaultKubeOperator(ApiClient client, String namespace) {
        this.coreApi.setApiClient(client);
        this.appsApi = new AppsV1Api();
        this.appsApi.setApiClient(client);
        this.customObjectsApi = new CustomObjectsApi();
        this.customObjectsApi.setApiClient(client);
        this.namespace = namespace;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }

    public ConcurrentMap<String, ConcurrentMap<String, String>> getAllSecretsWithLabel(Pair<String, String> label) {
        ConcurrentHashMap<String, ConcurrentMap<String, String>> secrets = new ConcurrentHashMap<String, ConcurrentMap<String, String>>();
        try {
            V1SecretList secretList = this.coreApi.listNamespacedSecret(this.namespace, null, null, null, null, (String)label.getKey() + "=" + (String)label.getValue(), null, null, null, null, null, null);
            List secretListItems = secretList.getItems();
            for (V1Secret secret : secretListItems) {
                V1ObjectMeta metadata = secret.getMetadata();
                if (metadata == null) continue;
                ConcurrentHashMap dataMap = new ConcurrentHashMap();
                if (secret.getData() != null) {
                    secret.getData().forEach((k, v) -> dataMap.put(k, new String((byte[])v)));
                }
                secrets.put(metadata.getName(), dataMap);
            }
        }
        catch (ApiException e) {
            if (e.getCode() != 404) {
                log.error(DEFAULT_ERR_MESSAGE + e.getResponseBody());
                throw new KubeApiException(DEFAULT_ERR_MESSAGE + e.getResponseBody(), (Exception)((Object)e));
            }
        }
        catch (Exception e) {
            log.error(DEFAULT_ERR_MESSAGE + e.getMessage());
            throw new KubeApiException(DEFAULT_ERR_MESSAGE + e.getMessage(), e);
        }
        return secrets;
    }

    @Override
    @Nullable
    public V1Secret getSecretObjectByName(String name) {
        try {
            return this.coreApi.readNamespacedSecret(name, this.namespace, null);
        }
        catch (ApiException e) {
            if (e.getCode() != 404) {
                log.error(DEFAULT_ERR_MESSAGE + e.getResponseBody());
                throw new KubeApiException(DEFAULT_ERR_MESSAGE + e.getResponseBody(), (Exception)((Object)e));
            }
            return null;
        }
        catch (Exception e) {
            log.error(DEFAULT_ERR_MESSAGE + e.getMessage());
            throw new KubeApiException(DEFAULT_ERR_MESSAGE + e.getMessage(), e);
        }
    }

    public ConcurrentMap<String, String> getSecretByName(String name, boolean failIfNotExist) throws KubeApiException {
        ConcurrentHashMap<String, String> secretMap = new ConcurrentHashMap<String, String>();
        try {
            V1Secret secret = this.coreApi.readNamespacedSecret(name, this.namespace, null);
            if (secret.getData() != null) {
                secret.getData().forEach((k, v) -> secretMap.put((String)k, new String((byte[])v)));
            }
        }
        catch (ApiException e) {
            if (failIfNotExist || e.getCode() != 404) {
                if (e.getCode() == 404) {
                    throw new KubeApiNotFoundException("Kube secret not found", (Exception)((Object)e));
                }
                log.error(DEFAULT_ERR_MESSAGE + e.getResponseBody());
                throw new KubeApiException(DEFAULT_ERR_MESSAGE + e.getResponseBody(), (Exception)((Object)e));
            }
        }
        catch (Exception e) {
            log.error(DEFAULT_ERR_MESSAGE + e.getMessage());
            throw new KubeApiException(DEFAULT_ERR_MESSAGE + e.getMessage(), e);
        }
        return secretMap;
    }

    @Override
    public void createSecret(String name, Pair<String, String> label, Map<String, String> data) {
        try {
            Map dataByte = data == null ? Collections.emptyMap() : data.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((String)entry.getValue()).getBytes()));
            V1Secret secret = new V1Secret();
            V1ObjectMeta metadata = new V1ObjectMeta();
            metadata.setName(name);
            metadata.setNamespace(this.namespace);
            metadata.setLabels(Collections.singletonMap((String)label.getKey(), (String)label.getValue()));
            secret.setMetadata(metadata);
            secret.setData(dataByte);
            this.coreApi.createNamespacedSecret(this.namespace, secret, null, null, null, null);
        }
        catch (ApiException e) {
            if (e.getCode() == 409) {
                throw new SecretAlreadyExists("Secret with name " + name + " already exists");
            }
            log.error(DEFAULT_ERR_MESSAGE + e.getResponseBody());
            throw new KubeApiException(DEFAULT_ERR_MESSAGE + e.getResponseBody(), (Exception)((Object)e));
        }
        catch (Exception e) {
            log.error(DEFAULT_ERR_MESSAGE + e.getMessage());
            throw new KubeApiException(DEFAULT_ERR_MESSAGE + e.getMessage(), e);
        }
    }

    public ConcurrentMap<String, String> addSecretData(String secretName, Map<String, String> data, boolean init) {
        ArrayList<JsonPatch> patches = new ArrayList<JsonPatch>();
        if (init) {
            patches.add(new JsonPatch(PatchOperation.ADD, SECRET_DATA_PATH, Collections.emptyMap()));
        }
        for (Map.Entry<String, String> entry : data.entrySet()) {
            patches.add(new JsonPatch(PatchOperation.ADD, this.getDataKeyPath(entry.getKey()), entry.getValue().getBytes()));
        }
        return this.updateSecretData(secretName, patches);
    }

    public ConcurrentMap<String, String> removeSecretData(String secretName, Set<String> keys) {
        List<JsonPatch> patches = keys.stream().map(key -> new JsonPatch(PatchOperation.REMOVE, this.getDataKeyPath((String)key), null)).toList();
        return this.updateSecretData(secretName, patches);
    }

    @Override
    public Call removeSecretDataAsync(String secretName, Set<String> keys, SecretUpdateCallback callback) {
        List<JsonPatch> patches = keys.stream().map(key -> new JsonPatch(PatchOperation.REMOVE, this.getDataKeyPath((String)key), null)).toList();
        try {
            return this.coreApi.patchNamespacedSecretAsync(secretName, this.namespace, new V1Patch(this.objectMapper.writeValueAsString(patches)), null, null, null, null, null, (ApiCallback)callback);
        }
        catch (JsonProcessingException e) {
            log.error("Unable to serialize secret patch request", (Throwable)e);
            throw new KubeApiException("Unable to serialize secret patch request", (Exception)((Object)e));
        }
        catch (ApiException e) {
            log.error(DEFAULT_ERR_MESSAGE + e.getResponseBody());
            throw new KubeApiException(DEFAULT_ERR_MESSAGE + e.getResponseBody(), (Exception)((Object)e));
        }
    }

    public ConcurrentMap<String, String> updateSecretData(String secretName, Map<String, String> data) {
        List<JsonPatch> patches = data.entrySet().stream().map(dataEntry -> new JsonPatch(PatchOperation.REPLACE, this.getDataKeyPath((String)dataEntry.getKey()), ((String)dataEntry.getValue()).getBytes())).toList();
        return this.updateSecretData(secretName, patches);
    }

    private ConcurrentMap<String, String> updateSecretData(String secretName, List<JsonPatch> patches) {
        ConcurrentHashMap<String, String> secretMap = new ConcurrentHashMap<String, String>();
        try {
            V1Secret secret = this.coreApi.patchNamespacedSecret(secretName, this.namespace, new V1Patch(this.objectMapper.writeValueAsString(patches)), null, null, null, null, null);
            if (secret.getData() != null) {
                secret.getData().forEach((k, v) -> secretMap.put((String)k, new String((byte[])v)));
            }
        }
        catch (JsonProcessingException e) {
            log.error("Unable to serialize secret patch request", (Throwable)e);
            throw new KubeApiException("Unable to serialize secret patch request", (Exception)((Object)e));
        }
        catch (ApiException e) {
            log.error(DEFAULT_ERR_MESSAGE + e.getResponseBody());
            throw new KubeApiException(DEFAULT_ERR_MESSAGE + e.getResponseBody(), (Exception)((Object)e));
        }
        return secretMap;
    }

    private String getDataKeyPath(String key) {
        return "/data/" + key;
    }
}

