/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.persistence.configs.repository.actionlog;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.actionlog.ActionLog;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.actionlog.EntityType;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.actionlog.LogOperation;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.enums.filter.ActionLogFilterColumn;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.enums.filter.FilterCondition;
import org.qubership.integration.platform.variables.management.persistence.configs.repository.actionlog.ActionLogFilterRepository;
import org.qubership.integration.platform.variables.management.rest.exception.ActionLogException;
import org.qubership.integration.platform.variables.management.rest.exception.InvalidEnumConstantException;
import org.qubership.integration.platform.variables.management.rest.v1.dto.actionlog.ActionLogFilterRequestDTO;

public class ActionLogFilterRepositoryImpl
implements ActionLogFilterRepository {
    private static final Map<ActionLogFilterColumn, Pair<String, Function<String, ?>>> FILTER_ENTITY_COLUMN_MAPPING = Map.of(ActionLogFilterColumn.ENTITY_ID, Pair.of((Object)"entityId", Function.identity()), ActionLogFilterColumn.ENTITY_NAME, Pair.of((Object)"entityName", Function.identity()), ActionLogFilterColumn.PARENT_ID, Pair.of((Object)"parentId", Function.identity()), ActionLogFilterColumn.PARENT_NAME, Pair.of((Object)"parentName", Function.identity()), ActionLogFilterColumn.REQUEST_ID, Pair.of((Object)"requestId", Function.identity()), ActionLogFilterColumn.OPERATION, Pair.of((Object)"operation", LogOperation::valueOf), ActionLogFilterColumn.ENTITY_TYPE, Pair.of((Object)"entityType", EntityType::valueOf), ActionLogFilterColumn.ACTION_TIME, Pair.of((Object)"actionTime", Function.identity()), ActionLogFilterColumn.INITIATOR, Pair.of((Object)"user.username", Function.identity()));
    private static final String ACTION_TIME_COLUMN = "actionTime";
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public List<ActionLog> findActionLogsByFilter(Timestamp offsetTime, long rangeTime, List<ActionLogFilterRequestDTO> filters) throws InvalidEnumConstantException {
        CriteriaQuery<ActionLog> query = this.buildFilterQuery(offsetTime, rangeTime, filters);
        return this.entityManager.createQuery(query).getResultList();
    }

    @Override
    public long getRecordsCountAfterTime(Timestamp timestamp, List<ActionLogFilterRequestDTO> filters) {
        CriteriaQuery<Long> query = this.getRecordsCount(timestamp, filters);
        return (Long)this.entityManager.createQuery(query).getSingleResult();
    }

    public CriteriaQuery<Long> getRecordsCount(Timestamp timestamp, List<ActionLogFilterRequestDTO> filters) {
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Long.class);
        Root actionLog = query.from(ActionLog.class);
        LinkedList<Predicate> predicates = new LinkedList<Predicate>();
        predicates.add(builder.lessThanOrEqualTo((Expression)actionLog.get(ACTION_TIME_COLUMN), (Comparable)timestamp));
        this.removeRedundantFilters(filters);
        this.addFiltersToQuery(filters, builder, (Root<ActionLog>)actionLog, predicates);
        query = query.select((Selection)builder.count((Expression)actionLog));
        Predicate finalPredicate = builder.and(predicates.toArray(new Predicate[0]));
        return !predicates.isEmpty() ? query.where((Expression)finalPredicate) : query;
    }

    private CriteriaQuery<ActionLog> buildFilterQuery(Timestamp offsetTime, long rangeTime, List<ActionLogFilterRequestDTO> filters) throws InvalidEnumConstantException {
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(ActionLog.class);
        Root actionLog = query.from(ActionLog.class);
        LinkedList<Predicate> predicates = new LinkedList<Predicate>();
        predicates.add(builder.greaterThan((Expression)actionLog.get(ACTION_TIME_COLUMN), (Comparable)new Timestamp(offsetTime.getTime() - rangeTime)));
        predicates.add(builder.lessThanOrEqualTo((Expression)actionLog.get(ACTION_TIME_COLUMN), (Comparable)offsetTime));
        this.removeRedundantFilters(filters);
        this.addFiltersToQuery(filters, builder, (Root<ActionLog>)actionLog, predicates);
        query = query.select((Selection)actionLog);
        Predicate finalPredicate = builder.and(predicates.toArray(new Predicate[0]));
        return (!predicates.isEmpty() ? query.where((Expression)finalPredicate) : query).orderBy(Collections.singletonList(builder.desc((Expression)actionLog.get(ACTION_TIME_COLUMN))));
    }

    private void addFiltersToQuery(List<ActionLogFilterRequestDTO> filters, CriteriaBuilder builder, Root<ActionLog> actionLog, List<Predicate> predicates) {
        for (ActionLogFilterColumn actionLogFilterColumn : ActionLogFilterColumn.values()) {
            for (ActionLogFilterRequestDTO filter : filters) {
                String value = filter.getValue();
                ActionLogFilterColumn column = filter.getColumn();
                Pair<String, Function<String, ?>> columnMapping = FILTER_ENTITY_COLUMN_MAPPING.get((Object)column);
                String columnName = (String)columnMapping.getKey();
                Function valueConverter = (Function)columnMapping.getValue();
                if (columnName == null) {
                    throw new ActionLogException("Filter column not found: " + String.valueOf((Object)column));
                }
                if (filter.getColumn() != actionLogFilterColumn) continue;
                Path valuePath = actionLog;
                for (String path : columnName.split("\\.")) {
                    valuePath = valuePath.get(path);
                }
                switch (filter.getCondition()) {
                    case IS: {
                        predicates.add(builder.equal((Expression)valuePath, (Object)value));
                        break;
                    }
                    case IS_NOT: {
                        predicates.add(builder.notEqual((Expression)valuePath, (Object)value));
                        break;
                    }
                    case CONTAINS: {
                        predicates.add(builder.like(builder.lower((Expression)valuePath), "%" + value.toLowerCase() + "%"));
                        break;
                    }
                    case DOES_NOT_CONTAIN: {
                        predicates.add(builder.notLike(builder.lower((Expression)valuePath), "%" + value.toLowerCase() + "%"));
                        break;
                    }
                    case STARTS_WITH: {
                        predicates.add(builder.like(builder.lower((Expression)valuePath), value.toLowerCase() + "%"));
                        break;
                    }
                    case ENDS_WITH: {
                        predicates.add(builder.like(builder.lower((Expression)valuePath), "%" + value.toLowerCase()));
                        break;
                    }
                    case EMPTY: {
                        predicates.add(builder.or((Expression)valuePath.isNull(), (Expression)builder.equal((Expression)valuePath, (Object)"")));
                        break;
                    }
                    case NOT_EMPTY: {
                        predicates.add(builder.and((Expression)valuePath.isNotNull(), (Expression)builder.notEqual((Expression)valuePath, (Object)"")));
                        break;
                    }
                    case IN: {
                        predicates.add(valuePath.in(Arrays.stream(value.split(",")).map(valueConverter).toList()));
                        break;
                    }
                    case NOT_IN: {
                        predicates.add(valuePath.in(Arrays.stream(value.split(",")).map(valueConverter).toList()).not());
                        break;
                    }
                    case IS_BEFORE: {
                        predicates.add(builder.lt((Expression)valuePath, (Number)Long.parseLong(value)));
                        break;
                    }
                    case IS_AFTER: {
                        predicates.add(builder.gt((Expression)valuePath, (Number)Long.parseLong(value)));
                        break;
                    }
                    case IS_WITHIN: {
                        String[] dates = value.split(",");
                        predicates.add(builder.between((Expression)valuePath, (Comparable)Long.valueOf(Long.parseLong(dates[0])), (Comparable)Long.valueOf(Long.parseLong(dates[1]))));
                    }
                }
            }
        }
    }

    private void removeRedundantFilters(List<ActionLogFilterRequestDTO> filters) {
        ArrayList<ActionLogFilterRequestDTO> filtersToRemove = new ArrayList<ActionLogFilterRequestDTO>();
        for (ActionLogFilterRequestDTO filter : filters) {
            if (!filter.getCondition().equals((Object)FilterCondition.IS)) continue;
            ActionLogFilterRequestDTO oppositeFilter = new ActionLogFilterRequestDTO();
            oppositeFilter.setValue(filter.getValue());
            oppositeFilter.setColumn(filter.getColumn());
            oppositeFilter.setCondition(FilterCondition.IS_NOT);
            if (!filters.contains(oppositeFilter)) continue;
            filtersToRemove.add(filter);
        }
        filters.removeAll(filtersToRemove);
    }
}

