/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.service;

import java.util.HashMap;
import java.util.Map;
import org.qubership.integration.platform.variables.management.configuration.ApplicationAutoConfiguration;
import org.qubership.integration.platform.variables.management.service.CommonVariablesService;
import org.qubership.integration.platform.variables.management.service.SecuredVariableService;
import org.qubership.integration.platform.variables.management.service.secrets.SecretService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;

@Component
public class DefaultVariablesService {
    private static final Logger log = LoggerFactory.getLogger(DefaultVariablesService.class);
    public static final String NAMESPACE_VARIABLE_NAME = "namespace";
    public static final String TENANT_VARIABLE_NAME = "tenant_id";
    public static final String[] DEFAULT_VARIABLES_LIST = new String[]{"namespace", "tenant_id"};
    private final SecretService secretService;
    private final CommonVariablesService commonVariablesService;
    private final SecuredVariableService securedVariableService;
    private final ApplicationAutoConfiguration applicationConfiguration;

    public DefaultVariablesService(SecretService secretService, CommonVariablesService commonVariablesService, SecuredVariableService securedVariableService, ApplicationAutoConfiguration applicationConfiguration) {
        this.secretService = secretService;
        this.commonVariablesService = commonVariablesService;
        this.securedVariableService = securedVariableService;
        this.applicationConfiguration = applicationConfiguration;
    }

    @Retryable(maxAttemptsExpression="${listeners.RestoreVariablesListener.call-retry.max-attempts}", backoff=@Backoff(delayExpression="${listeners.RestoreVariablesListener.call-retry.delay}"))
    public void restoreVariables() {
        try {
            log.debug("Restore variables started");
            this.secretService.createSecret(this.secretService.getDefaultSecretName());
            Map<String, String> defaultCommonVariables = this.getDefaultCommonVariables();
            this.securedVariableService.deleteVariables(this.secretService.getDefaultSecretName(), defaultCommonVariables.keySet(), false);
            this.commonVariablesService.addVariablesUnlogged(defaultCommonVariables);
            log.debug("Restore variables finished");
        }
        catch (Exception e) {
            MDC.put((String)"error_code", (String)"8050");
            log.warn("Retry of Event Listener failed with error: failed to restore variables: {}", (Object)e.getMessage());
            MDC.remove((String)"error_code");
            throw e;
        }
    }

    private Map<String, String> getDefaultCommonVariables() {
        HashMap<String, String> defaultCommonVariables = new HashMap<String, String>();
        defaultCommonVariables.put(NAMESPACE_VARIABLE_NAME, this.applicationConfiguration.getNamespace());
        return defaultCommonVariables;
    }
}

