/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.service;

import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.actionlog.ActionLog;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.actionlog.EntityType;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.user.User;
import org.qubership.integration.platform.variables.management.persistence.configs.repository.actionlog.ActionLogRepository;
import org.qubership.integration.platform.variables.management.rest.exception.InvalidEnumConstantException;
import org.qubership.integration.platform.variables.management.rest.v1.dto.actionlog.ActionLogSearchCriteria;
import org.qubership.integration.platform.variables.management.service.ActionsLogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.AuditorAware;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActionsLogService {
    private static final Logger log = LoggerFactory.getLogger(ActionsLogService.class);
    private final ActionLogRepository actionLogRepository;
    private final AuditorAware<User> auditor;
    private final BlockingQueue<ActionLog> queue = new LinkedBlockingQueue();

    @Autowired
    public ActionsLogService(ActionLogRepository actionLogRepository, AuditorAware<User> auditor) {
        this.actionLogRepository = actionLogRepository;
        this.auditor = auditor;
        new ActionWriterThread(actionLogRepository, this.queue).start();
    }

    public Pair<Long, List<ActionLog>> findBySearchRequest(ActionLogSearchCriteria request) {
        try {
            List actionLogsByFilter = this.actionLogRepository.findActionLogsByFilter(request.getOffsetTime(), request.getRangeTime(), request.getFilters());
            long recordsAfterRange = this.actionLogRepository.getRecordsCountAfterTime(new Timestamp(request.getOffsetTime().getTime() - request.getRangeTime()), request.getFilters());
            return Pair.of((Object)recordsAfterRange, (Object)actionLogsByFilter);
        }
        catch (InvalidEnumConstantException e) {
            log.debug(e.getMessage());
            return Pair.of((Object)0L, Collections.emptyList());
        }
    }

    public List<ActionLog> findAllByActionTimeBetween(Timestamp actionTimeFrom, Timestamp actionTimeTo) {
        return this.actionLogRepository.findAllByActionTimeBetween(actionTimeFrom, actionTimeTo);
    }

    public boolean logAction(ActionLog action) {
        this.injectCurrentUser(action);
        this.injectRequestId(action);
        try {
            if (!this.queue.offer(action)) {
                log.error("Queue of actions is full, element is not added, {}", (Object)this.maskSecretName(action));
                return false;
            }
            this.consoleLogAction(this.maskSecretName(action));
            return true;
        }
        catch (Exception e) {
            log.error("Failed to save action log to database: {}", (Object)this.maskSecretName(action), (Object)e);
            return false;
        }
    }

    private void injectRequestId(ActionLog action) {
        action.setRequestId(MDC.get((String)"requestId"));
    }

    private void injectCurrentUser(ActionLog action) {
        this.auditor.getCurrentAuditor().ifPresent(arg_0 -> ((ActionLog)action).setUser(arg_0));
    }

    @Transactional
    public void deleteAllOldRecordsByInterval(String olderThan) {
        this.actionLogRepository.deleteAllOldRecordsByInterval(olderThan);
    }

    private void consoleLogAction(ActionLog action) {
        MDC.put((String)"logType", (String)"audit");
        StringBuilder sb = new StringBuilder();
        sb.append("Action ");
        sb.append(Optional.ofNullable(action.getOperation()).map(Enum::name).orElse("-"));
        sb.append(" for ");
        sb.append(Optional.ofNullable(action.getEntityType()).map(Enum::name).orElse("-"));
        Optional.ofNullable(action.getEntityName()).ifPresent(name -> sb.append(" with name ").append((String)name));
        Optional.ofNullable(action.getEntityId()).ifPresent(id -> sb.append(" with id: ").append((String)id));
        Optional.ofNullable(action.getParentType()).ifPresent(type -> sb.append(" under parent entity ").append(type.name()));
        Optional.ofNullable(action.getParentName()).ifPresent(name -> sb.append(" with name ").append((String)name));
        Optional.ofNullable(action.getParentId()).ifPresent(id -> sb.append(" with id: ").append((String)id));
        Optional.ofNullable(action.getUser().getUsername()).ifPresent(name -> sb.append(" performed by user ").append((String)name));
        Optional.ofNullable(action.getUser().getId()).ifPresent(id -> sb.append(" with id: ").append((String)id));
        log.debug(sb.toString());
        MDC.remove((String)"logType");
    }

    private ActionLog maskSecretName(ActionLog actionLog) {
        ActionLog.ActionLogBuilder builder = actionLog.toBuilder();
        if (actionLog.getEntityType() == EntityType.SECRET) {
            builder.entityName("Secret");
        }
        if (actionLog.getParentType() == EntityType.SECRET) {
            builder.parentName("Secret");
        }
        return builder.build();
    }
}

