/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import jakarta.persistence.EntityExistsException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.integration.platform.variables.management.kubernetes.SecretUpdateCallback;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.actionlog.ActionLog;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.actionlog.EntityType;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.actionlog.LogOperation;
import org.qubership.integration.platform.variables.management.rest.exception.EmptyVariableFieldException;
import org.qubership.integration.platform.variables.management.rest.exception.SecretNotFoundException;
import org.qubership.integration.platform.variables.management.rest.exception.SecuredVariablesException;
import org.qubership.integration.platform.variables.management.rest.exception.SecuredVariablesNotFoundException;
import org.qubership.integration.platform.variables.management.rest.v2.dto.variables.SecretErrorResponse;
import org.qubership.integration.platform.variables.management.service.ActionsLogService;
import org.qubership.integration.platform.variables.management.service.CommonVariablesService;
import org.qubership.integration.platform.variables.management.service.secrets.SecretService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SecuredVariableService {
    private static final Logger log = LoggerFactory.getLogger(SecuredVariableService.class);
    public static final String EMPTY_SECURED_VARIABLE_NAME_ERROR_MESSAGE = "Secured variable's name is empty";
    private final SecretService secretService;
    private final ActionsLogService actionLogger;
    private final YAMLMapper yamlMapper;
    private final CommonVariablesService commonVariablesService;
    private final Lock lock;

    @Autowired
    public SecuredVariableService(SecretService secretService, ActionsLogService actionLogger, @Lazy CommonVariablesService commonVariablesService, @Qualifier(value="yamlMapper") YAMLMapper yamlMapper) {
        this.secretService = secretService;
        this.actionLogger = actionLogger;
        this.commonVariablesService = commonVariablesService;
        this.yamlMapper = yamlMapper;
        this.lock = new ReentrantLock(true);
    }

    public Map<String, Set<String>> getAllSecretsVariablesNames() {
        this.lock.lock();
        try {
            Map<String, Set<String>> map = this.secretService.getAllSecretsData().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Map)entry.getValue()).keySet()));
            return map;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Set<String> getVariablesForDefaultSecret(boolean failIfSecretNotExist) {
        return this.getVariablesForSecret(this.secretService.getDefaultSecretName(), failIfSecretNotExist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getVariablesForSecret(String secretName, boolean failIfSecretNotExist) {
        this.lock.lock();
        try {
            Set<String> set = this.secretService.getSecretData(secretName, failIfSecretNotExist).keySet();
            return set;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Set<String> addVariablesToDefaultSecret(Map<String, String> newVariables) {
        String secretName = this.secretService.getDefaultSecretName();
        return this.addVariables(secretName, newVariables).get(secretName);
    }

    public Map<String, Set<String>> addVariables(String secretName, Map<String, String> newVariables) {
        return this.addVariables(secretName, newVariables, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Set<String>> addVariables(String secretName, Map<String, String> newVariables, boolean importMode) {
        Map<String, String> variables;
        if (newVariables.isEmpty()) {
            return Collections.singletonMap(secretName, Collections.emptySet());
        }
        this.lock.lock();
        try {
            variables = this.secretService.getSecretData(secretName, true);
            if (this.secretService.isDefaultSecret(secretName)) {
                this.validateSecuredVariablesUniqueness(variables, newVariables);
            }
            newVariables.forEach(this::validateSecuredVariable);
            this.secretService.addEntries(secretName, newVariables, variables.isEmpty());
        }
        finally {
            this.lock.unlock();
        }
        newVariables.keySet().forEach(name -> {
            LogOperation operation = importMode ? LogOperation.IMPORT : (variables.containsKey(name) ? LogOperation.UPDATE : LogOperation.CREATE);
            this.logSecuredVariableAction((String)name, secretName, operation);
        });
        return Collections.singletonMap(secretName, newVariables.keySet());
    }

    public void deleteVariablesFromDefaultSecret(Set<String> variablesNames) {
        this.deleteVariables(this.secretService.getDefaultSecretName(), variablesNames);
    }

    public void deleteVariables(String secretName, Set<String> variablesNames) {
        this.deleteVariables(secretName, variablesNames, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteVariables(String secretName, Set<String> variablesNames, boolean logOperation) {
        Set<String> existedVariables;
        if (CollectionUtils.isEmpty(variablesNames)) {
            return;
        }
        this.lock.lock();
        try {
            existedVariables = this.secretService.getSecretData(secretName, true).keySet();
            this.secretService.removeEntries(secretName, variablesNames);
        }
        finally {
            this.lock.unlock();
        }
        if (logOperation) {
            variablesNames.stream().filter(existedVariables::contains).forEach(name -> this.logSecuredVariableAction((String)name, secretName, LogOperation.DELETE));
        }
    }

    public List<SecretErrorResponse> deleteVariablesForMultipleSecrets(Map<String, Set<String>> variablesPerSecret) {
        Map<String, ? extends Map<String, String>> variablesBySecret;
        ArrayList secretUpdateFutures = new ArrayList();
        HashMap secretUpdateExceptions = new HashMap();
        this.lock.lock();
        try {
            variablesBySecret = this.secretService.getAllSecretsData();
            variablesPerSecret.forEach((secretName, variablesToRemove) -> {
                boolean secretExists = variablesBySecret.containsKey(secretName);
                if (!secretExists) {
                    secretUpdateExceptions.put(secretName, SecretNotFoundException.forSecret(secretName));
                    return;
                }
                try {
                    CompletionStage future = new CompletableFuture().whenComplete((secretData, throwable) -> {
                        if (throwable != null) {
                            secretUpdateExceptions.put(secretName, throwable);
                        }
                    });
                    secretUpdateFutures.add(future);
                    this.secretService.removeEntriesAsync((String)secretName, (Set<String>)variablesToRemove, new SecretUpdateCallback((CompletableFuture<Map<String, String>>)future));
                }
                catch (Exception e) {
                    secretUpdateExceptions.putIfAbsent(secretName, new SecuredVariablesException("Failed to delete variables from secret: " + secretName, e));
                }
            });
            CompletableFuture.allOf(secretUpdateFutures.toArray(new CompletableFuture[0])).get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("Failed to delete variables", (Throwable)e);
            throw new SecuredVariablesException("Failed to delete variables", e);
        }
        finally {
            this.lock.unlock();
        }
        variablesPerSecret.entrySet().stream().filter(entry -> !secretUpdateExceptions.containsKey(entry.getKey())).forEach(entry -> ((Set)entry.getValue()).stream().filter(variable -> ((Map)variablesBySecret.get(entry.getKey())).containsKey(variable)).forEach(variable -> this.logSecuredVariableAction((String)variable, (String)entry.getKey(), LogOperation.DELETE)));
        if (!secretUpdateExceptions.isEmpty()) {
            ArrayList<SecretErrorResponse> errorResponses = new ArrayList<SecretErrorResponse>();
            for (Map.Entry entry2 : secretUpdateExceptions.entrySet()) {
                errorResponses.add(new SecretErrorResponse((String)entry2.getKey(), ((Throwable)entry2.getValue()).getMessage()));
                log.error("Failed to delete variables from secret {}", entry2.getKey(), entry2.getValue());
            }
            if (secretUpdateExceptions.keySet().containsAll(variablesPerSecret.keySet())) {
                throw new SecuredVariablesException("Failed to delete variables from multiple secrets");
            }
            return errorResponses;
        }
        return Collections.emptyList();
    }

    public String updateVariableInDefaultSecret(String name, String value) {
        this.updateVariables(this.secretService.getDefaultSecretName(), Collections.singletonMap(name, value));
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<String, Set<String>> updateVariables(String secretName, Map<String, String> variablesToUpdate) {
        this.lock.lock();
        try {
            HashMap<String, String> variables = new HashMap<String, String>(this.secretService.getSecretData(secretName, true));
            for (Map.Entry<String, String> variable : variablesToUpdate.entrySet()) {
                String name2 = variable.getKey();
                String value = variable.getValue();
                this.validateSecuredVariable(name2, value);
                if (!variables.containsKey(name2)) {
                    throw new SecuredVariablesNotFoundException("Cannot find variable " + name2);
                }
                variables.put(name2, Objects.isNull(value) ? "" : value);
            }
            this.secretService.updateEntries(secretName, variables);
        }
        finally {
            this.lock.unlock();
        }
        variablesToUpdate.keySet().forEach(name -> this.logSecuredVariableAction((String)name, secretName, LogOperation.UPDATE));
        return Pair.of((Object)secretName, variablesToUpdate.keySet());
    }

    public Set<String> importVariablesRequest(MultipartFile file) {
        Map importedVariables;
        try {
            importedVariables = (Map)this.yamlMapper.readValue(new String(file.getBytes()), (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (IOException e) {
            log.error("Unable to convert file to variables {}", (Object)e.getMessage());
            throw new RuntimeException("Unable to convert file to variables");
        }
        String secretName = this.secretService.getDefaultSecretName();
        return this.addVariables(secretName, importedVariables, true).get(secretName);
    }

    private void validateSecuredVariable(String name, String value) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new EmptyVariableFieldException(EMPTY_SECURED_VARIABLE_NAME_ERROR_MESSAGE);
        }
    }

    private void validateSecuredVariablesUniqueness(Map<String, String> currentVariables, Map<String, String> newVariables) {
        Map<String, String> commonVariables = this.commonVariablesService.getVariables();
        for (Map.Entry<String, String> commonVariable : commonVariables.entrySet()) {
            String name = commonVariable.getKey();
            if (!currentVariables.containsKey(name) && !newVariables.containsKey(name)) continue;
            throw new EntityExistsException("Common variable with name " + name + " already exists");
        }
    }

    private void logSecuredVariableAction(String name, String secretName, LogOperation operation) {
        ActionLog action = ActionLog.builder().entityType(EntityType.SECURED_VARIABLE).entityName(name).parentType(EntityType.SECRET).parentName(secretName).operation(operation).build();
        this.actionLogger.logAction(action);
    }
}

