/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.configuration;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.util.ClientBuilder;
import io.kubernetes.client.util.credentials.AccessTokenAuthentication;
import io.kubernetes.client.util.credentials.Authentication;
import io.kubernetes.client.util.credentials.TokenFileAuthentication;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Optional;
import org.qubership.integration.platform.variables.management.kubernetes.DefaultKubeOperator;
import org.qubership.integration.platform.variables.management.kubernetes.KubeOperator;
import org.qubership.integration.platform.variables.management.kubernetes.LocalDevKubeOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
public class KubeOperatorAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(KubeOperatorAutoConfiguration.class);
    private final String uri;
    private final String namespace;
    private final String token;
    private final String cert;

    @Autowired
    public KubeOperatorAutoConfiguration(@Value(value="${kubernetes.cluster.uri}") String uri, @Value(value="${kubernetes.cluster.namespace}") String namespace, @Value(value="${kubernetes.service-account.token}") String token, @Value(value="${kubernetes.service-account.cert}") String cert, @Value(value="${kubernetes.cluster.token:#{null}}") Optional<String> devToken) {
        this.uri = uri;
        this.namespace = namespace;
        this.token = devToken.orElse(token);
        this.cert = cert;
    }

    @Bean
    @ConditionalOnProperty(prefix="kubernetes", name={"devmode"}, havingValue="false", matchIfMissing=true)
    public KubeOperator kubeOperator() {
        try {
            log.info("Creating KubernetesOperator bean in PROD mode");
            ApiClient client = new ClientBuilder().setVerifyingSsl(false).setBasePath(this.uri).setCertificateAuthority(Files.readAllBytes(Paths.get(this.cert, new String[0]))).setAuthentication((Authentication)new TokenFileAuthentication(this.token)).build();
            return new DefaultKubeOperator(client, this.namespace);
        }
        catch (Exception e) {
            log.error("Invalid k8s cluster parameters, can't initialize k8s API. {}", (Object)e.getMessage());
            return new DefaultKubeOperator();
        }
    }

    @Bean
    @ConditionalOnExpression(value="${kubernetes.devmode:false} and !${kubernetes.localdev:false}")
    public KubeOperator kubeOperatorDev() {
        try {
            log.info("Creating KubernetesOperator bean in DEV mode");
            ApiClient client = new ClientBuilder().setVerifyingSsl(false).setBasePath(this.uri).setAuthentication((Authentication)new AccessTokenAuthentication(this.token)).build();
            return new DefaultKubeOperator(client, this.namespace);
        }
        catch (Exception e) {
            log.error("Invalid k8s cluster parameters, can't initialize k8s API. {}", (Object)e.getMessage());
            return new DefaultKubeOperator();
        }
    }

    @Bean
    @ConditionalOnExpression(value="${kubernetes.devmode:false} and ${kubernetes.localdev:false}")
    public KubeOperator kubeOperatorLocalDev() {
        log.info("Creating KubernetesOperator for local development mode");
        return new LocalDevKubeOperator();
    }
}

