/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.sql.Timestamp;
import org.qubership.integration.platform.variables.management.service.exportimport.ActionsLogExportService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(value={"/v1/actions-log/export"})
@Tag(name="actions-log-export-controller", description="Actions Log Export Controller")
public class ActionsLogExportController {
    private static final Logger log = LoggerFactory.getLogger(ActionsLogExportController.class);
    private final ActionsLogExportService actionsLogExportService;

    @Autowired
    public ActionsLogExportController(ActionsLogExportService actionsLogExportService) {
        this.actionsLogExportService = actionsLogExportService;
    }

    @Operation(description="Export action log as a file")
    @GetMapping(value={""})
    public ResponseEntity<Object> export(@RequestParam @Parameter(description="Timestamp from") Long actionTimeFrom, @RequestParam @Parameter(description="Timestamp to") Long actionTimeTo) {
        log.info("Request to export actions log");
        byte[] document = this.actionsLogExportService.exportAsExcelDocument(new Timestamp(actionTimeFrom), new Timestamp(actionTimeTo));
        return this.asResponse(document);
    }

    private ResponseEntity<Object> asResponse(byte[] document) {
        HttpHeaders header = new HttpHeaders();
        header.add("Content-Disposition", "attachment; filename=variables-management-actions-log.xlsx");
        header.add("Access-Control-Expose-Headers", "Content-Disposition");
        ByteArrayResource resource = new ByteArrayResource(document);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(header)).contentLength(resource.contentLength()).body((Object)resource);
    }
}

