/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import jakarta.persistence.EntityExistsException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.integration.platform.variables.management.consul.ConsulService;
import org.qubership.integration.platform.variables.management.model.exportimport.instructions.PerformInstructionsResult;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.actionlog.ActionLog;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.actionlog.EntityType;
import org.qubership.integration.platform.variables.management.persistence.configs.entity.actionlog.LogOperation;
import org.qubership.integration.platform.variables.management.rest.exception.EmptyVariableFieldException;
import org.qubership.integration.platform.variables.management.rest.exception.MalformedVariableNameException;
import org.qubership.integration.platform.variables.management.rest.v1.dto.variables.ImportVariableDTO;
import org.qubership.integration.platform.variables.management.rest.v1.dto.variables.ImportVariablePreview;
import org.qubership.integration.platform.variables.management.rest.v1.dto.variables.ImportVariableStatus;
import org.qubership.integration.platform.variables.management.rest.v1.dto.variables.VariablesFileResponse;
import org.qubership.integration.platform.variables.management.rest.v2.dto.variables.ImportVariablesResult;
import org.qubership.integration.platform.variables.management.service.ActionsLogService;
import org.qubership.integration.platform.variables.management.service.DefaultVariablesService;
import org.qubership.integration.platform.variables.management.service.SecuredVariableService;
import org.qubership.integration.platform.variables.management.service.exportimport.instructions.ImportInstructionsService;
import org.qubership.integration.platform.variables.management.util.ExportImportUtils;
import org.qubership.integration.platform.variables.management.validation.EntityValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CommonVariablesService {
    private static final Logger log = LoggerFactory.getLogger(CommonVariablesService.class);
    private static final String VARIABLES_PREFIX = "common-variables";
    private static final String VAR_PARENT_DIR = "variables";
    protected static final String ZIP_EXTENSION = "zip";
    private static final String YAML_EXTENSION = "yaml";
    private static final String YML_EXTENSION = "yml";
    private static final String EMPTY_COMMON_VARIABLE_NAME_ERROR_MESSAGE = "Common variable's name is empty";
    private final ActionsLogService actionLogger;
    private final YAMLMapper yamlMapper;
    private final SecuredVariableService securedVariableService;
    private final ConsulService consulService;
    private final ImportInstructionsService importInstructionsService;

    @Autowired
    public CommonVariablesService(ActionsLogService actionLogger, @Qualifier(value="yamlImportExportMapper") YAMLMapper yamlImportExportMapper, SecuredVariableService securedVariableService, ConsulService consulService, ImportInstructionsService importInstructionsService) {
        this.actionLogger = actionLogger;
        this.yamlMapper = yamlImportExportMapper;
        this.securedVariableService = securedVariableService;
        this.consulService = consulService;
        this.importInstructionsService = importInstructionsService;
    }

    public Map<String, String> getVariables() {
        return this.consulService.getAllCommonVariables();
    }

    public String addVariable(String key, String value) {
        if (!EntityValidator.VARIABLE_NAME_PATTERN_PREDICATE.test(key)) {
            throw new MalformedVariableNameException(key);
        }
        Set securedVariablesNames = this.securedVariableService.getVariablesForDefaultSecret(false);
        ImportVariableDTO commonVariable = this.checkAndMapVariable(key, value, securedVariablesNames, false);
        this.consulService.updateCommonVariable(key, value);
        return commonVariable.getName();
    }

    public List<ImportVariableDTO> addVariables(Map<String, String> variables, boolean importMode) {
        List<ImportVariableDTO> importDTOs = Collections.emptyList();
        if (!variables.isEmpty()) {
            Set securedVariablesNames = this.securedVariableService.getVariablesForDefaultSecret(false);
            importDTOs = variables.entrySet().stream().map(entry -> this.checkAndMapVariable((String)entry.getKey(), (String)entry.getValue(), securedVariablesNames, importMode)).toList();
            this.consulService.updateCommonVariables(variables);
        }
        return importDTOs;
    }

    private ImportVariableDTO checkAndMapVariable(String key, String value, Set<String> securedVariablesNames, boolean importMode) {
        if (securedVariablesNames.contains(key)) {
            throw new EntityExistsException("Secured variable with name " + key + " already exists");
        }
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new EmptyVariableFieldException(EMPTY_COMMON_VARIABLE_NAME_ERROR_MESSAGE);
        }
        if (!EntityValidator.VARIABLE_NAME_PATTERN_PREDICATE.test(key)) {
            throw new MalformedVariableNameException(key);
        }
        ImportVariableDTO variable = new ImportVariableDTO(key, value);
        Pair oldVar = this.consulService.getCommonVariable(key);
        boolean exists = oldVar != null;
        variable.setStatus(exists ? ImportVariableStatus.UPDATED : ImportVariableStatus.CREATED);
        LogOperation operation = importMode ? LogOperation.IMPORT : (exists ? LogOperation.UPDATE : LogOperation.CREATE);
        this.logCommonVariableAction(key, operation);
        return variable;
    }

    public void addVariablesUnlogged(Map<String, String> variables) {
        this.consulService.updateCommonVariables(variables);
    }

    public void deleteVariables(List<String> variablesNames) {
        this.consulService.deleteCommonVariables(variablesNames);
        variablesNames.forEach(name -> this.logCommonVariableAction(name, LogOperation.DELETE));
    }

    public VariablesFileResponse exportVariables(List<String> variablesNames, boolean asArchive) {
        Map<String, String> variablesForExport = CollectionUtils.isEmpty(variablesNames) ? this.consulService.getAllCommonVariables() : this.consulService.getCommonVariables(variablesNames);
        if ((variablesForExport = variablesForExport.entrySet().stream().filter(name -> DefaultVariablesService.DEFAULT_VARIABLES_LIST.stream().noneMatch(excludedName -> excludedName.equals(name.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).isEmpty()) {
            return null;
        }
        variablesForExport.forEach((k, v) -> this.logCommonVariableAction(k, LogOperation.EXPORT));
        byte[] contentBytes = this.stringMapAsByteArr(variablesForExport);
        if (asArchive) {
            VariablesFileResponse variablesFileResponse;
            ByteArrayOutputStream fos = new ByteArrayOutputStream();
            try {
                try (ZipOutputStream zipOut = new ZipOutputStream(fos);){
                    String path = VAR_PARENT_DIR + File.separator;
                    zipOut.putNextEntry(new ZipEntry(path));
                    zipOut.closeEntry();
                    zipOut.putNextEntry(new ZipEntry(path + this.exportVariablesGenerateFilename(false)));
                    zipOut.write(contentBytes, 0, contentBytes.length);
                    zipOut.closeEntry();
                }
                variablesFileResponse = new VariablesFileResponse(fos.toByteArray(), this.exportVariablesGenerateFilename(true));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Unknown exception while archive creation: " + e.getMessage());
                }
            }
            fos.close();
            return variablesFileResponse;
        }
        return new VariablesFileResponse(contentBytes, this.exportVariablesGenerateFilename(false));
    }

    public ImportVariablesResult importVariables(MultipartFile file, Set<String> variablesNames) {
        Map variablesForImport;
        String fileExtension = FilenameUtils.getExtension((String)file.getOriginalFilename());
        if (ZIP_EXTENSION.equalsIgnoreCase(fileExtension)) {
            variablesForImport = this.importVariableZip(file);
        } else if (YAML_EXTENSION.equalsIgnoreCase(fileExtension) || YML_EXTENSION.equalsIgnoreCase(fileExtension)) {
            try {
                variablesForImport = this.importVariablesFile(file.getBytes());
            }
            catch (Exception e) {
                log.error("Unable to convert file to variables {}", (Object)e.getMessage());
                throw new RuntimeException("Unable to convert file to variables");
            }
        } else {
            throw new RuntimeException("Unsupported file extension: " + fileExtension);
        }
        PerformInstructionsResult ignoreResult = this.importInstructionsService.performIgnoreInstructions(variablesForImport.keySet());
        Set variablesToIgnore = ignoreResult.variablesToIgnore();
        ArrayList importVariableDTOS = new ArrayList(this.addVariables(variablesForImport.entrySet().stream().filter(entry -> !variablesToIgnore.contains(entry.getKey())).filter(entry -> variablesNames == null || variablesNames.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)), true));
        variablesToIgnore.stream().map(variableName -> ImportVariableDTO.builder().name(variableName).value((String)variablesForImport.get(variableName)).status(ImportVariableStatus.IGNORED).build()).forEach(importVariableDTOS::add);
        return ImportVariablesResult.builder().variables(importVariableDTOS).instructions(ignoreResult.importInstructionsExecutionResults()).build();
    }

    private Map<String, String> importVariableZip(MultipartFile file) {
        List extractedSystemFiles;
        Map variablesForImport = Collections.emptyMap();
        String directoryForExport = "/tmp/" + UUID.randomUUID().toString();
        try (InputStream is = file.getInputStream();){
            extractedSystemFiles = this.extractVariablesFromZip(is, directoryForExport);
        }
        catch (IOException e) {
            ExportImportUtils.deleteFile((String)directoryForExport);
            throw new RuntimeException("Unexpected error while archive unpacking: " + e.getMessage());
        }
        catch (RuntimeException e) {
            ExportImportUtils.deleteFile((String)directoryForExport);
            throw e;
        }
        try {
            if (!extractedSystemFiles.isEmpty()) {
                variablesForImport = this.importVariablesFile(Files.readString(((File)extractedSystemFiles.get(0)).toPath()));
            }
        }
        catch (IOException e) {
            log.error("Unable to convert file to variables {}", (Object)e.getMessage());
            throw new RuntimeException("Unable to convert file to variables");
        }
        finally {
            ExportImportUtils.deleteFile((String)directoryForExport);
        }
        return variablesForImport;
    }

    public List<ImportVariablePreview> importVariablePreview(MultipartFile file) {
        Map newVariables;
        String fileExtension = FilenameUtils.getExtension((String)file.getOriginalFilename());
        if (YAML_EXTENSION.equalsIgnoreCase(fileExtension) || YML_EXTENSION.equalsIgnoreCase(fileExtension)) {
            try {
                newVariables = this.importVariablesFile(file.getBytes());
            }
            catch (Exception e) {
                log.error("Unable to convert file to preview variables {}", (Object)e.getMessage());
                throw new RuntimeException("Unable to convert file to preview variables");
            }
        } else if (ZIP_EXTENSION.equalsIgnoreCase(fileExtension)) {
            newVariables = this.importVariableZip(file);
        } else {
            throw new RuntimeException("Unsupported file extension: " + fileExtension);
        }
        Map currentVariables = this.getVariables();
        return newVariables.entrySet().stream().map(entry -> new ImportVariablePreview((String)entry.getKey(), (String)entry.getValue(), currentVariables.getOrDefault(entry.getKey(), ""))).collect(Collectors.toList());
    }

    private List<File> extractVariablesFromZip(InputStream is, String directoryForExport) throws IOException {
        List<File> result = Collections.emptyList();
        Path path = Paths.get(directoryForExport, new String[0]);
        try (ZipInputStream inputStream = new ZipInputStream(is);){
            ZipEntry entry;
            while ((entry = inputStream.getNextEntry()) != null) {
                Path resolvedPath = path.resolve(entry.getName()).normalize();
                String entryName = entry.getName();
                Path entryPath = Paths.get(entryName, new String[0]);
                if (!entryPath.startsWith(VAR_PARENT_DIR) || !resolvedPath.startsWith(path)) continue;
                if (entryName.contains("..") || entryPath.isAbsolute()) {
                    throw new SecurityException("Invalid ZIP entry: " + entryName);
                }
                if (!entry.isDirectory()) {
                    Files.createDirectories(resolvedPath.getParent(), new FileAttribute[0]);
                    Files.copy(inputStream, resolvedPath, new CopyOption[0]);
                    Files.setLastModifiedTime(resolvedPath, FileTime.fromMillis(entry.getTime()));
                    continue;
                }
                Files.createDirectories(resolvedPath, new FileAttribute[0]);
            }
        }
        Path importPath = Paths.get(directoryForExport + File.separator + VAR_PARENT_DIR, new String[0]);
        if (Files.exists(importPath, new LinkOption[0])) {
            try (Stream<Path> ps = Files.walk(importPath, new FileVisitOption[0]);){
                result = ps.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toFile).filter(f -> f.getName().startsWith(VARIABLES_PREFIX) && f.getName().endsWith(YAML_EXTENSION)).collect(Collectors.toList());
            }
        }
        return result;
    }

    private Map<String, String> importVariablesFile(byte[] file) throws JsonProcessingException {
        return this.importVariablesFile(new String(file));
    }

    private Map<String, String> importVariablesFile(String file) throws JsonProcessingException {
        return (Map)this.yamlMapper.readValue(file, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    private String exportVariablesGenerateFilename(boolean isArchive) {
        return "common-variables." + (isArchive ? ZIP_EXTENSION : YAML_EXTENSION);
    }

    private byte[] stringMapAsByteArr(Map<String, String> variablesForExport) {
        try {
            return this.yamlMapper.writeValueAsString(variablesForExport).getBytes();
        }
        catch (JsonProcessingException e) {
            log.error("Unable to convert variables to file {}", (Object)e.getMessage());
            throw new RuntimeException("Unable to convert variables to file");
        }
    }

    private void logCommonVariableAction(String name, LogOperation operation) {
        this.actionLogger.logAction(ActionLog.builder().entityType(EntityType.COMMON_VARIABLE).entityName(name).operation(operation).build());
    }
}

