/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.consul;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.qubership.integration.platform.variables.management.consul.ConsulClient;
import org.qubership.integration.platform.variables.management.consul.KVNotFoundException;
import org.qubership.integration.platform.variables.management.model.consul.txn.KVResponse;
import org.qubership.integration.platform.variables.management.model.consul.txn.KeyResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ConsulService {
    private static final Logger log = LoggerFactory.getLogger(ConsulService.class);
    private final ConsulClient client;
    @Value(value="${consul.keys.prefix}")
    private String keyPrefix;
    @Value(value="${consul.keys.engine-config-root}")
    private String keyEngineConfigRoot;
    @Deprecated(since="24.1")
    @Value(value="${consul.keys.common-variables-v1}")
    public String keyCommonVariables;
    @Value(value="${consul.keys.common-variables-v2}")
    private String keyCommonVariablesV2;

    @Autowired
    public ConsulService(ConsulClient client) {
        this.client = client;
    }

    @Nullable
    public Pair<String, String> getCommonVariable(String key) {
        try {
            List<KeyResponse> response = this.client.getKV(this.buildCommonVariableKey(key), false);
            return response.isEmpty() ? null : this.parseCommonVariable(response.get(0));
        }
        catch (KVNotFoundException kvnfe) {
            return null;
        }
    }

    public Map<String, String> getCommonVariables(List<String> variablesNames) {
        List<KVResponse> response = this.client.getKVsInTransaction(variablesNames.stream().map(this::buildCommonVariableKeyForTxn).toList());
        return response.stream().map(this::parseCommonVariable).filter(Objects::nonNull).collect(Collectors.toMap(Pair::getKey, ConsulService.nullValueRemapping()));
    }

    @Deprecated(since="24.1")
    public Map<String, String> getTenantCommonVariablesLegacy(String tenantId) {
        return this.getStringStringMapLegacy(this.keyCommonVariables + "/" + tenantId);
    }

    public Map<String, String> getAllCommonVariables() {
        return this.getStringStringMap(this.keyCommonVariablesV2);
    }

    public boolean commonVariablesKvExists() {
        try {
            this.client.getKV(this.keyPrefix + this.keyEngineConfigRoot + this.keyCommonVariablesV2, true);
            return true;
        }
        catch (KVNotFoundException kvnfe) {
            return false;
        }
    }

    @Deprecated(since="24.1")
    @NotNull
    private Map<String, String> getStringStringMapLegacy(String key) {
        return this.getStringStringMap(key, this::parseCommonVariable);
    }

    @NotNull
    private Map<String, String> getStringStringMap(String key) {
        return this.getStringStringMap(key, this::parseCommonVariable);
    }

    @NotNull
    private Map<String, String> getStringStringMap(String key, Function<KeyResponse, Pair<String, String>> responseParser) {
        try {
            String keyPrefix = this.keyPrefix + this.keyEngineConfigRoot + key;
            List<KeyResponse> responses = this.client.getKV(keyPrefix, true);
            return responses.stream().filter(keyResponse -> ConsulService.filterL1NonEmptyPaths(keyPrefix, keyResponse.getKey())).map(responseParser).filter(Objects::nonNull).collect(Collectors.toMap(Pair::getKey, ConsulService.nullValueRemapping()));
        }
        catch (KVNotFoundException kvnfe) {
            return Collections.emptyMap();
        }
    }

    @NotNull
    private static Function<Pair<String, String>, String> nullValueRemapping() {
        return pair -> pair.getValue() == null ? "" : (String)pair.getValue();
    }

    public void deleteLegacyVariablesKV() {
        this.client.deleteKV(this.keyPrefix + this.keyEngineConfigRoot + this.keyCommonVariables, true);
    }

    public void deleteCommonVariable(String key) {
        this.client.deleteKV(this.buildCommonVariableKey(key), false);
    }

    public void deleteCommonVariables(List<String> variablesNames) {
        this.client.deleteKVsInTransaction(variablesNames.stream().map(this::buildCommonVariableKeyForTxn).toList());
    }

    public void updateCommonVariable(String key, String value) {
        this.client.createOrUpdateKV(this.buildCommonVariableKey(key), value);
    }

    public void updateCommonVariables(Map<String, String> variables) {
        this.client.createOrUpdateKVsInTransaction(variables.entrySet().stream().collect(Collectors.toMap(entry -> this.buildCommonVariableKeyForTxn((String)entry.getKey()), Map.Entry::getValue)));
    }

    @NotNull
    private String buildCommonVariableKey(String key) {
        return this.keyPrefix + this.keyEngineConfigRoot + this.keyCommonVariablesV2 + "/" + key;
    }

    @NotNull
    private String buildCommonVariableKeyForTxn(String key) {
        return this.buildCommonVariableKey(key).replaceFirst("^/", "");
    }

    private Pair<String, String> parseCommonVariable(KVResponse k) {
        String[] split = k.getKey().split("/");
        return split.length > 0 ? Pair.of((Object)split[split.length - 1], (Object)k.getDecodedValue()) : null;
    }

    private static boolean filterL1NonEmptyPaths(String pathPrefix, String path) {
        String[] split = path.substring(pathPrefix.length()).split("/");
        return split.length == 1 && StringUtils.isNotEmpty((CharSequence)split[0]);
    }
}

